<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit Products')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0"><?php echo e(__('Edit Products')); ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.alert','data' => []]); ?>
<?php $component->withName('alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                        <!-- users edit account form start -->
                        <form method="POST" action="<?php echo e(route('products.update',$product->id)); ?>"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="row">
                                
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="name" class="form-label"><?php echo e(__('Arabic Name')); ?></label>
                                        <input type="text"  class="form-control" id="name_ar" name="name_ar" value="<?php echo e(old('name_ar',$product->name_ar)); ?>" required autofocus >
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="name" class="form-label"><?php echo e(__('English Name')); ?></label>
                                        <input type="text"  class="form-control" id="name_en" name="name_en" value="<?php echo e(old('name_en',$product->name_en)); ?>" required autofocus >
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="code" class="form-label"><?php echo e(__('Product ID')); ?></label>
                                        <input type="text"  class="form-control" id="code" name="code" value="<?php echo e(old('code',$product->code)); ?>">
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="price" class="form-label"><?php echo e(__('Product Price')); ?></label>
                                        <input type="text"  class="form-control" id="price" name="price" value="<?php echo e(old('price',$product->price)); ?>" required>
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <div class="form-group">
                                            <label for="category_id" class="form-label"><?php echo e(__('Perant Category Name')); ?></label>
                                            <select name="category_id" id="category_id" class="form-control">
                                                <?php $__currentLoopData = App\Models\Category::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if($category->id == old('category_id',$product->subCategory->category_id)): ?> selected  <?php endif; ?> value="<?php echo e($category->id); ?>"><?php if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'): ?><?php echo e($category->name_ar); ?><?php else: ?><?php echo e($category->name_en); ?><?php endif; ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <div class="form-group">
                                            <label for="category_id" class="form-label"><?php echo e(__('Sub Category Name')); ?></label>
                                            <select name="sub_category_id" id="sub_category_id" class="form-control">
                                                <option value="">يجب اختيار التصنيف الرئيسي</option>
                                                <?php $__currentLoopData = App\Models\SubCategory::where('category_id',$product->subCategory->category_id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if($category->id == old('sub_category_id',$product->sub_category_id)): ?> selected  <?php endif; ?> value="<?php echo e($category->id); ?>"><?php if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'): ?><?php echo e($category->name_ar); ?><?php else: ?><?php echo e($category->name); ?><?php endif; ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                
                                 
                                 <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="short_description_ar" class="form-label"><?php echo e(__('Arabic Short Description')); ?></label>
                                        <textarea name="short_description_ar" class="form-control" cols="30" rows="5"><?php echo e(old('short_description_ar',$product->short_description_ar)); ?></textarea>
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="short_description_en" class="form-label"><?php echo e(__('English Short Description')); ?></label>
                                        <textarea name="short_description_en" class="form-control" cols="30" rows="5"><?php echo e(old('short_description_en',$product->short_description_en)); ?></textarea>
                                    </div>
                                </div>
                                
                                
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="big_description_ar" class="form-label"><?php echo e(__('Arabic Big Description')); ?></label>
                                        <textarea name="big_description_ar" id="big_description_ar" class="form-control" cols="30" rows="10"><?php echo e(old('big_description_ar',$product->big_description_ar)); ?></textarea>
                                    </div>
                                </div>
                                
                                <script>
                                    CKEDITOR.replace('big_description_ar');
                                </script>

                                
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="big_description_en" class="form-label"><?php echo e(__('English Big Description')); ?></label>
                                        <textarea name="big_description_en" id="big_description_en" class="form-control" cols="30" rows="10"><?php echo e(old('big_description_en',$product->big_description_en)); ?></textarea>
                                    </div>
                                </div>
                                
                                <script>
                                    CKEDITOR.replace('big_description_en');
                                </script>


                                
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <?php if($product->main_image): ?>
                                        <img src="<?php echo e(asset('storage/'.$product->main_image)); ?>" width="100" alt="...">
                                    <?php endif; ?>
                                    <div class="form-group fallback w-100">
                                        <label for="main_image" class="form-label"><?php echo e(__('Main Image')); ?></label>
                                        <input type="file" id="main_image" name="main_image" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="link" class="form-label"><?php echo e(__('رابط الفيديو')); ?></label>
                                        <input type="url" name="link" class="form-control"  id="link" value="<?php echo e(old('link',$product->link)); ?>">
                                    </div>
                                </div>
                                

                                
                                <div class="col-lg-8 col-md-8 col-sm-8">
                                    <div class="form-group fallback w-100">
                                        <label for="file" class="form-label"><?php echo e(__('File')); ?></label>
                                        <input type="file" id="file" name="file" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                

                                <?php if($product->file): ?>
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <a href="<?php echo e(asset('storage/'.$product->file)); ?>" target="_blank" class="btn btn-primary mt-2"><?php echo e(__('View File')); ?></a>
                                </div>
                                <?php endif; ?>

                                
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check form-check-inline">
                                            Delete <input type="checkbox" name="<?php echo e("check_".$gallery->id); ?>" class="form-check-input" value="">
                                        </div>
                                        <img src="<?php echo e(asset('storage/'.$gallery->image)); ?>" width="100" alt="...">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group fallback w-100">
                                        <label for="gallery" class="form-label"><?php echo e(__('Other Gallery Image')); ?></label>
                                        <input type="file" multiple id="gallery" name="gallery[]" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Submit')); ?></button>
                                    <button type="reset" class="btn btn-light"><?php echo e(__('Cencel')); ?></button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    // Department Change
    $('#category_id').change(function () {

        // Department id
        var id = $(this).val();

        // AJAX request
        $.ajax({
            url: '/control-panel/sub_category/ajax/' + id,
            type: 'get',
            data: "json",
            success: function (data) {
                $('select[name="sub_category_id"]').empty();
                $('select[name="sub_category_id"]').append('<option value="">يجب اختيار التصنيف الرئيسي</option>');
                $.each(data, function (key, value) {
                    // console.log(value.name)
                    $('select[name="sub_category_id"]').append('<option value="' + value.id + '">' + value.name + '</option>')
                });

            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ahmed\Documents\GitHub\3dit-printing\resources\views/control-panel/products/edit.blade.php ENDPATH**/ ?>