<?php

use App\Http\Controllers\ControlPanel\AboutUsController;
use App\Http\Controllers\ControlPanel\BenefitsController;
use App\Http\Controllers\ControlPanel\BlogController;
use App\Http\Controllers\ControlPanel\BranchController;
use App\Http\Controllers\ControlPanel\CategoriesController;
use App\Http\Controllers\ControlPanel\CategoryTextController;
use App\Http\Controllers\ControlPanel\ClientController;
use App\Http\Controllers\ControlPanel\ClientOpinionController;
use App\Http\Controllers\ControlPanel\ClientsContoller;
use App\Http\Controllers\ControlPanel\ContactController as ControlPanelContactController;
use App\Http\Controllers\ControlPanel\DashboardController;
use App\Http\Controllers\ControlPanel\EmploymentApplication;
use App\Http\Controllers\ControlPanel\FAQController;
use App\Http\Controllers\ControlPanel\JopNameController;
use App\Http\Controllers\ControlPanel\OrderController as ControlPanelOrderController;
use App\Http\Controllers\ControlPanel\OrderProductsController;
use App\Http\Controllers\ControlPanel\PageController;
use App\Http\Controllers\ControlPanel\PageFeaturesController;
use App\Http\Controllers\ControlPanel\PageThemesController;
use App\Http\Controllers\ControlPanel\PartnersController;
use App\Http\Controllers\ControlPanel\PhotoAlbumController;
use App\Http\Controllers\ControlPanel\PlanController;
use App\Http\Controllers\ControlPanel\PriseController;
use App\Http\Controllers\ControlPanel\ProductsController;
use App\Http\Controllers\ControlPanel\ProductTextController;
use App\Http\Controllers\ControlPanel\ProjectController;
use App\Http\Controllers\ControlPanel\ServiceTextController;
use App\Http\Controllers\ControlPanel\SubServiceController;
use App\Http\Controllers\ControlPanel\TeamController;
use App\Http\Controllers\ControlPanel\UserController;
use App\Http\Controllers\ControlPanel\SliderController;
use App\Http\Controllers\ControlPanel\SpecialtyController;
use App\Http\Controllers\ControlPanel\StepsContoller;
use App\Http\Controllers\ControlPanel\StudyCasesController;
use App\Http\Controllers\ControlPanel\StudyCategoriesController;
use App\Http\Controllers\ControlPanel\SubCategoriesContoller;
use App\Http\Controllers\ControlPanel\VedioAlbumController;
use App\Http\Controllers\ControlPanel\WebsitController;
use App\Http\Controllers\SiteController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::prefix(LaravelLocalization::setLocale())
        ->group(function () {
            // Route::get('/', function () {
            //     return view('frontend.index');
            // });
            Route::get('/foo', function () {
                Artisan::call('config:clear');
                Artisan::call('optimize:clear');
            });


            // Route::get('/dashbourd', function () {
            //     dd('hello');
            //     return view('control-panel.dashboard');
            // });

            Route::group([
            //    'prefix' => LaravelLocalization::setLocale(),
                'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
            ], function () {
            // Control Panel Routs
                Route::middleware(['auth'])
                    ->prefix('control-panel')
                    ->group(function () {
                        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

                        Route::get('users', [UserController::class, 'index'])->name('all-users');
                        Route::get('users/create', [UserController::class, 'create'])->name('create-users');
                        Route::post('users/create', [UserController::class, 'store'])->name('store-users');
                        Route::get('users/{user}/edit', [UserController::class, 'edit'])->name('edit-users');
                        Route::put('users/{user}', [UserController::class, 'update'])->name('update-users');
                        Route::delete('users', [UserController::class, 'destroy'])->name('delete-users');

                        Route::get('setting/website-setting', [WebsitController::class, 'edit'])->name('setting-website-edit');
                        Route::post('setting/website-setting', [WebsitController::class, 'update'])->name('setting-website-update');

                        Route::get('service-text', [ServiceTextController::class, 'edit'])->name('service-text-edit');
                        Route::post('service-text', [ServiceTextController::class, 'update'])->name('service-text-update');

                        Route::get('category-text', [CategoryTextController::class, 'edit'])->name('category-text-edit');
                        Route::post('category-text', [CategoryTextController::class, 'update'])->name('category-text-update');

                        Route::get('product-text', [ProductTextController::class, 'edit'])->name('product-text-edit');
                        Route::post('product-text', [ProductTextController::class, 'update'])->name('product-text-update');

                        Route::get('about-us', [AboutUsController::class, 'edit'])->name('about-us-edit');
                        Route::post('about-us', [AboutUsController::class, 'update'])->name('about-us-update');

                        Route::resource('services', App\Http\Controllers\ControlPanel\ServiceController::class);
                        Route::resource('subservices', SubServiceController::class);
                        Route::resource('clients', ClientController::class);
                        Route::resource('client-opinion', ClientOpinionController::class);
                        Route::resource('prises', PriseController::class);
                        Route::resource('projects', ProjectController::class);
                        Route::resource('faqs', FAQController::class);
                        Route::resource('categories', CategoriesController::class);
                        Route::resource('products', ProductsController::class);
                        Route::resource('benefits', BenefitsController::class);
                        Route::resource('partners', PartnersController::class);
                        Route::resource('study-categories', StudyCategoriesController::class);
                        Route::resource('steps', StepsContoller::class);
                        Route::resource('clients', ClientsContoller::class);
                        Route::resource('sub-categories', SubCategoriesContoller::class);
                        Route::get('benefit/{id}/sub-benefit', [BenefitsController::class, 'viewSubBenefit'])->name('sub-benefit.index');
                        Route::post('benefit/{id}/sub-benefit', [BenefitsController::class, 'storeSubBenefit'])->name('sub-benefit.store');

                        Route::resource('pages', PageController::class);
                        Route::resource('features', PageFeaturesController::class)->except(['index', 'create', 'store', 'edit', 'show']);
                        Route::get('features/{page}', [PageFeaturesController::class, 'index'])->name('features.index');
                        Route::post('features/{page}', [PageFeaturesController::class, 'store'])->name('features.store');
                        Route::resource('themes', PageThemesController::class)->except(['index', 'create', 'store', 'edit', 'show']);
                        Route::get('themes/{page}', [PageThemesController::class, 'index'])->name('themes.index');
                        Route::post('themes/{page}', [PageThemesController::class, 'store'])->name('themes.store');

                        Route::resource('branches', BranchController::class);
                        Route::resource('jobs', JopNameController::class);
                        Route::resource('blogs', BlogController::class);
                        Route::resource('study-cases', StudyCasesController::class);
                        Route::resource('teams', TeamController::class);
                        Route::resource('orders', ControlPanelOrderController::class);
                        Route::get('contacts', [ControlPanelContactController::class, 'index'])->name('contacts.index');
                        Route::get('contacts/{contact}', [ControlPanelContactController::class, 'show'])->name('contacts.show');
                        Route::delete('contacts/{contact}', [ControlPanelContactController::class, 'destroy'])->name('contacts.destroy');
                        Route::get('order-products', [OrderProductsController::class, 'index'])->name('order-products.index');
                        Route::get('order-products/{order_product}', [OrderProductsController::class, 'show'])->name('order-products.show');
                        Route::delete('order-products/{order_product}', [OrderProductsController::class, 'destroy'])->name('order-products.destroy');
                        Route::resource('sliders', SliderController::class);

                        Route::get('employment-application', [EmploymentApplication::class, 'index'])->name('employment-application.index');
                        Route::get('employment-application/{employment}', [EmploymentApplication::class, 'show'])->name('employment-application.show');
                        Route::delete('employment-application/{employment}', [EmploymentApplication::class, 'destroy'])->name('employment-application.destroy');

                        Route::resource('specialties', SpecialtyController::class);

                        Route::resource('photo-album', PhotoAlbumController::class);
                        Route::put('photo-album/{photo_album}/photos', [PhotoAlbumController::class, 'updatePhotos'])->name('photo-album.updatePhotos');
                        Route::resource('vedio-album', VedioAlbumController::class);

                        Route::get('plans/{service}', [PlanController::class, 'show'])->name('plans.show');
                        Route::get('plans/create/{service}', [PlanController::class, 'create'])->name('plans.create');
                        Route::post('plans/create', [PlanController::class, 'store'])->name('plans.store');
                        Route::get('plans/{plan}/edit', [PlanController::class, 'edit'])->name('plans.edit');
                        Route::put('plans/{plan}/edit', [PlanController::class, 'update'])->name('plans.update');
                        Route::delete('plans/{plan}', [PlanController::class, 'destroy'])->name('plans.destroy');

                        Route::resource('menus', \App\Http\Controllers\ControlPanel\MenuController::class);

                        Route::get('sub-menu/ajax/{id}', [PageController::class, 'getSubMenus'])->name('subMenu.ajax');
                        Route::get('sub_category/ajax/{id}',[SubCategoriesContoller::class,'getSubCategories']);
                    });


                Route::as('view.')
                    ->group(function () {
                        Route::get('/', [SiteController::class, 'index'])->name('index');
                        Route::get('/page/{page}', [SiteController::class, 'page'])->name('page');
                        Route::get('/about', [SiteController::class, 'about'])->name('about');
                        Route::get('/blogs', [SiteController::class, 'blogs'])->name('blogs');
                        Route::get('/press', [SiteController::class, 'press'])->name('press');
                        Route::get('/blogs/{blog}', [SiteController::class, 'blogDetials'])->name('blog-detials');
                        Route::get('/products/{sub}', [SiteController::class, 'products'])->name('products');
                        Route::get('/product/{product}', [SiteController::class, 'productDetails'])->name('product');
                        Route::post('/product/order/{product}', [SiteController::class, 'productOrder'])->name('product.order');
                        Route::get('/study-cases', [SiteController::class, 'caseStudy'])->name('study-cases');
                        Route::get('/study-cases/{study_case}', [SiteController::class, 'caseStudyDetials'])->name('study-cases-detials');
                        Route::get('/contact', [SiteController::class, 'contact'])->name('contact');
                        Route::post('/contact', [SiteController::class, 'storeContact']);
                        // Route::get('/site/categories', [VeiwController::class, 'categoryView'])->name('category.page');
                        // Route::get('/site/categories/{id}', [VeiwController::class, 'productsView'])->name('products.page');
                        // Route::get('/site/blogs', [VeiwController::class, 'blogsView'])->name('blogs.page');
                        // Route::get('/site/contact-us', [VeiwController::class, 'contactUsView'])->name('contact-us.page');
                        // Route::get('/site/about-us', [VeiwController::class, 'aboutUsView'])->name('about-us.page');
                        // Route::post('/site/contact-us', [VeiwController::class, 'contactUsPost'])->name('contact-us.store');
                        // Route::get('/site/trining', [VeiwController::class, 'triningView'])->name('trining.page');
                        // Route::get('/site/podiatry', [VeiwController::class, 'podiatryView'])->name('podiatry.page');
                        // Route::get('/site/blogs/{id}', [VeiwController::class, 'singleBlogsView'])->name('singleBlogs.page');
                        // Route::get('/site/products/{id}', [VeiwController::class, 'singleProduct'])->name('singleProduct.page');
                        // Route::get('/site/search/products', [VeiwController::class, 'productsSearch'])->name('productsSearch.page');

                    });
            });
            require __DIR__ . '/auth.php';
        });
