@if ($paginator->hasPages())
    <nav class="text-center">
        <ul class="pagination" style="display: inline-block;">

            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="page-item disabled" aria-disabled="true" style="font-size: 16px;">
                    <span class="page-link">@lang('pagination.previous')</span>
                </li>
            @else
                <li class="page-item" style="font-size: 16px;">
                    <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">@lang('pagination.previous')</a>
                </li>
            @endif

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="page-item" style="font-size: 16px;">
                    <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">@lang('pagination.next')</a>
                </li>
            @else
                <li class="page-item disabled" aria-disabled="true" style="font-size: 16px;">
                    <span class="page-link">@lang('pagination.next')</span>
                </li>
            @endif

        </ul>
    </nav>
@endif
