@if ($paginator->hasPages())
    {{-- Pagination Elements --}}
    @foreach ($elements as $element)
        {{-- "Three Dots" Separator --}}
        @if (is_string($element))
            <span class="swiper-pagination-bullet" tabindex="0">{{ $element }}</span>
        @endif

        {{-- Array Of Links --}}
        @if (is_array($element))
            @foreach ($element as $page => $url)
                @if ($page == $paginator->currentPage())
                    <span class="swiper-pagination-bullet swiper-pagination-bullet-active" style="width: 40px;
                    height: 40px;
                    text-align: center;
                    line-height: 20px;
                    font-size: 20px;
                    color: #fff;;
                    opacity: 1;
                    padding-top: 10px;
                    background: #EC6707;"  tabindex="0">{{ $page }}</span>
                @else
                <span class="swiper-pagination-bullet" tabindex="0" style="width: 40px;
                height: 40px;
                text-align: center;
                line-height: 20px;
                font-size: 20px;
                color: #000;
                opacity: 1;
                padding-top: 10px;
                background: rgba(0, 0, 0, 0.2);"><a href="{{ $url }}">{{ $page }}</a></span>
                @endif
            @endforeach
        @endif
    @endforeach

@endif
