@extends('front.layout.pages')
@section('title')
    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        حالات الدراسة
    @else
        Study Cases
    @endif
@stop
@section('content')

    <section class="land-sec py-5 land-sec1   landsecbg   wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center text-md-start">
            <div class="row  align-items-center  ">
                <div class="col-xl-5 col-lg-6 text-white text-start mb-4 wow fadeInLeft" data-wow-duration="2s"
                    data-wow-delay=".5s">
                    <h5 class="  mb-3">

                    </h5>
                    <h1 class="mb-3 fw-bold" style="font-size: 50px;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ App\Models\ServiceText::first()->title1_ar ?? '' }}
                        @else
                            {{ App\Models\ServiceText::first()->title1 ?? '' }}
                        @endif
                    </h1>
                    <p class=" prg" style="margin-bottom: 4rem;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ Str::limit(App\Models\ServiceText::first()->description1_ar ?? '', 600, '...') }}
                        @else
                            {{ Str::limit(App\Models\ServiceText::first()->description1 ?? '', 600, '...') }}
                        @endif
                    </p>
                    <a data-bs-toggle="modal" data-bs-target="#exampleModal1"
                        class="btn btn-top  rounded-3 shadow shadow-sm fs-4"
                        style="padding: 11px 4rem;">{{ __('Get a Quote') }} </a>

                </div>

            </div>
        </div>
    </section>



    <section class="my-5 ms-0">
        <div class="swiper mySwiper">
            <div class="swiper-wrapper">
                <div class="swiper-slide mx-lg-auto w-100">
                    @foreach ($study_cases as $key => $study_case)
                        <div class="container mx-auto border border-1 pt-5 pb-4 my-5 wow @if ($key % 2 == 0) fadeInLeftBig @else fadeInRightBig @endif"
                            data-wow-duration="2s" data-wow-delay=".5s" style="border-radius: 8px;">
                            <div class="row justify-content-around align-items-center">

                                <div class="col-md-5 mb-3 ">
                                    <img src="{{ asset('storage/' . $study_case->main_image) }}" class="img-fluid"
                                        alt="">
                                </div>
                                <div class="col-md-6  mb-3">
                                    <h3 class="">
                                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ $study_case->title_ar ?? '' }}
                                        @else
                                            {{ $study_case->title ?? '' }}
                                        @endif
                                    </h3>
                                    <div class=" sign my-3">
                                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ $study_case->studyCategory->name_ar ?? '' }}
                                        @else
                                            {{ $study_case->studyCategory->name ?? '' }}
                                        @endif
                                    </div>
                                    <p class="p prg3" style="line-height: 28px;">
                                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ Str::limit($study_case->shot_desc_ar, 600, '...') }}
                                        @else
                                            {{ Str::limit($study_case->shot_desc, 600, '...') }}
                                        @endif
                                    </p>
                                    <a href="{{ route('view.study-cases-detials', $study_case->id) }}" class="card-link">{{ __('See the Full Story') }} <i
                                            class=" ms-3 bi bi-arrow-right rmo-ico"></i> </a>

                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="swiper-pagination position-relative my-5 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">{{ $study_cases->links('vendor.pagination.bootstrap-4') }}</div>

        </div>

    </section>

@stop

{{-- @section('js')
    <script>
        var swiper = new Swiper(".mySwiper", {
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
                renderBullet: function (index, className) {
                return '<span class="' + className + '">' + (index + 1) + "</span>";
                },
            },
        });
    </script>

@stop --}}
