@extends('front.layout.pages')
@section('title')
    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        المنتجات
    @else
        Products
    @endif
@stop
@section('content')

    <section class="land-sec    wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s"
        style="overflow-y: hidden; background-color: #FAFAFA;">
        <div class="container text-center text-md-start">
            <div class="row  align-items-center justify-content-between ">
                <div class="col-xl-6 col-lg-7 text-white  mb-4 wow fadeInLeft" data-wow-duration="2s" data-wow-delay=".5s">
                    <h1 class="mb-4 fw-bold" style="font-size: 50px; color: #56227A;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $sub_category->name_ar }}
                        @else
                            {{ $sub_category->name }}
                        @endif
                    </h1>
                    <p class="mb-lg-5 prg1" style="color: #716F72; ;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ Str::limit($sub_category->description_ar, 600, '...') }}
                        @else
                            {{ Str::limit($sub_category->description, 600, '...') }}
                        @endif
                    </p>
                    <a class=" btn btn-top rounded-3 shadow shadow-sm fs-4"  data-bs-toggle="modal" data-bs-target="#exampleModal1" style="padding: 11px 4rem;">{{ __('Contact Sales') }}</a>

                </div>
                <div class="col-lg-5  mb-4 wow" data-wow-duration="2s" data-wow-delay=".5s">
                    <img src="{{ asset('storage/' . $sub_category->image) }}" class=" img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>




    <section class="my-5 wow fadeInUp shop " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container">
            <div class="text-start " style="margin-bottom: 7rem;">
                <h1 style="color: #2C113E;">{{ __('Applications') }}</h1>
            </div>
            <div class=" row   prod">
                @foreach($sub_category->products as $product)
                    <div style="margin-bottom: 5rem;" class="col-lg-4 col-md-6  px-4 wow fadeInUp  " data-wow-duration="2s"
                        data-wow-delay=".5s">
                        <a href="{{ route('view.product', $product->id) }}"> <img src="{{ asset('storage/'.$product->main_image) }}" class="img-fluid w-100" style="background-color: #F2F4F4;"
                                alt=""></a>
                        <h4 class="prg2 mt-5" style="color: #2C113E;">
                            @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $product->name_ar }}
                            @else
                                {{ $product->name_en }}
                            @endif
                        </h4>
                        <p class="p prg2 mt-4 mb-5" style="line-height: 25px; color: #716F72;">
                            @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ Str::limit($product->short_description_ar, 600, '...') }}
                            @else
                                {{ Str::limit($product->short_description_en, 600, '...') }}
                            @endif
                        </p>

                        <a class=" btn btn-top rounded-3 shadow shadow-sm fs-5" href="{{ route('view.product', $product->id) }}" style="padding: 11px 4rem;">{{ __('Read More') }} </a>

                    </div>
                @endforeach
            </div>
        </div>
    </section>

    <section class=" endse mb-0 wow fadeInUp  " style="background-color: #FAFAFA; margin-top: 12rem; padding: 6rem 0 ;"
        data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center ">
            <div class="row text-center">
                <div class="col-lg-7 mx-auto">
                    <h1>{{ __('Want to start with 3DIT?') }}
                    </h1>
                    <p class="prg1 mt-4" style="color: #716F72;">
                        {{ __('The choice of the right 3D printing technology for depends on the projected size and number of the models. Reach out to learn more about how to open new possibilities to scale your business.') }}
                    </p>

                    <a data-bs-toggle="modal" data-bs-target="#exampleModal1"
                        class="btn btn-top  rounded-3 shadow shadow-sm fs-4 mt-5" style="padding: 11px 4rem;">
                        {{ __('Get a Quote') }}
                    </a>
                </div>
            </div>

        </div>
    </section>
@stop
