@extends('front.layout.pages')
@section('title')
    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        المنتجات
    @else
        Products
    @endif
@stop
@section('content')

    <section class="top-sec py-5 wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center ">
            <div class="row  align-items-center ">
                <div class="col-lg-6 text-lg-start">
                    <p class="title">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $product->name_ar }}
                        @else
                            {{ $product->name_en }}
                        @endif
                    </p>
                </div>
                <div class="col-lg-6 text-lg-end">
                    <p>
                        <a href="#" class="sup-title"> <span>{{ __('Home') }} </span></a>

                        <i class="bi bi-caret-right-fill mx-3"></i>
                        <a href="#" class="sup-title"> <span>
                                @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $product->subCategory->category->name_ar }}
                                @else
                                    {{ $product->subCategory->category->name_en }}
                                @endif
                            </span></a>
                        <i class="bi bi-caret-right-fill mx-3"></i>
                        <a href="{{ route('view.products',$product->subCategory->id) }}" class="sup-title"> <span>
                                @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $product->subCategory->name_ar }}
                                @else
                                    {{ $product->subCategory->name }}
                                @endif
                            </span></a>
                        <i class="bi bi-caret-right-fill mx-3"></i>
                        <a href="#" class="sup-title">
                            <span>
                                @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $product->name_ar }}
                                @else
                                    {{ $product->name_en }}
                                @endif
                            </span>
                        </a>
                    </p>
                </div>

            </div>
        </div>
    </section>



    <div class="container mx-auto  pt-5 pb-4 mt-5  wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s"
        style="border-radius: 8px; margin-bottom: 5rem;">
        <div class="row justify-content-around align-items-center">

            <div class="col-md-5 mb-3 ">
                <div class="product-imgs">
                    <div class="img-display">
                        <div class="img-showcase">
                            <img class="shoe" src="{{ asset('storage/' . $product->main_image) }}" alt="shoe image">
                            @foreach ($product->images as $image)
                                <img class="shoe" src="{{ asset('storage/' . $image->image) }}" alt="shoe image">
                            @endforeach
                        </div>
                    </div>
                    <div class="img-select">
                        <div class="img-item">
                            <a href="#" data-id="1">
                                <img src="{{ asset('storage/' . $product->main_image) }}" alt="shoe image">
                            </a>
                        </div>
                        @foreach ($product->images as $key => $image)
                            <div class="img-item">
                                <a href="#" data-id="{{ $key + 2 }}">
                                    <img src="{{ asset('storage/' . $image->image) }}" alt="shoe image">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="col-md-6  mb-3">
                <h5 style="color: #716F72;" class="">SKU: {{ $product->code }}</h5>
                <h2 style="color: #2C113E;" class=" my-3">
                    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                        {{ $product->name_ar }}
                    @else
                        {{ $product->name_en }}
                    @endif
                </h2>
                <p class="p prg" style="line-height: 28px; color: #716F72;">
                    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                        {{ Str::limit($product->short_description_ar, 600, '...') }}
                    @else
                        {{ Str::limit($product->short_description_en, 600, '...') }}
                    @endif
                </p>
                <h2 style="color: var(--color1);" class=" my-3">
                    $ {{ $product->price }}
                </h2>

                <form action="{{ route('view.product.order', $product->id) }}" id="orderForm" method="POST">
                    @csrf
                    <div class="counter">
                        <span class="down" onClick='decreaseCount(event, this)'>-</span>
                        <input type="number" name="quentity" value="1">
                        <span class="up" onClick='increaseCount(event, this)'>+</span>

                    </div>
                    <div class="modal fade" id="product_order" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog  modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="container text-center">
                                        <div class="mt-2 mb-4 border-1 border-bottom py-3">
                                            <h2 style="color: var(--color1);" class="fw-bold">{{ __('Get a Quote') }}</h2>
                                        </div>
                                        <div class="row text-start my-5">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">{{ __('Name') }}</label>
                                                    <input type="text" class="form-control shadow-none" name="full_name"
                                                        id="full_name" aria-describedby="emailHelp">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="exampleInputEmail1"
                                                        class="form-label">{{ __('Email address') }}</label>
                                                    <input type="email" class="form-control shadow-none" name="email"
                                                        id="email" aria-describedby="emailHelp">

                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="exampleInputPassword1"
                                                        class="form-label">{{ __('Phone No') }}</label>
                                                    <input type="text " class="form-control shadow-none" name="phone"
                                                        id="phone">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label for="exampleInputPassword1"
                                                        class="form-label">{{ __('Company Name') }}</label>
                                                    <input type="text " class="form-control shadow-none" name="company_name"
                                                        id="company_name">
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="mb-3">
                                                    <label for="exampleInputPassword1"
                                                        class="form-label">{{ __('Description') }}</label>
                                                    <textarea rows="5" class="form-control shadow-none" name="message" id="message"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mt-3">
                                                <div class="h-captcha my-0" data-sitekey="194e8efb-f32d-4d44-8ffb-b54694c2f321">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-center mb-4 ">
                                        <button type="submit" class="btn btn-top1 py-3 rounded-3 shadow shadow-sm fs-4"
                                            style="padding: 0 5rem;" id="order_submit"
                                            onclick="submitOrder()">{{ __('Submit') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn btn-top w-100 mt-3 rounded-3 shadow shadow-sm fs-4"
                        style="padding: 11px 4rem;" data-bs-toggle="modal" data-bs-target="#product_order">{{ __('Request A Quote') }} </button>
                </form>
                {{--
                <h4 style="color: #2C113E;" class=" my-5">
                    Product Addons
                </h4>
                <div class="row ">
                    <div class="img-item col " data-toggle="tooltip" data-bs-html="true"
                        title="<h4> title</h4> <h6> 1200 </h6>">
                        <a href="#">
                            <img src="images/dsc_1449.png" alt="shoe image">

                        </a>
                    </div>
                    <div class="img-item col" data-toggle="tooltip" data-bs-html="true"
                        title="<h4> title</h4> <h6> 1200 </h6>">
                        <a href="#">
                            <img src="images/w1.png" alt="shoe image">
                        </a>
                    </div>
                    <div class="img-item col" data-toggle="tooltip" data-bs-html="true"
                        title="<h4> title</h4> <h6> 1200 </h6>">
                        <a href="#">
                            <img src="images/w2.png" alt="shoe image " data-bs-toggle="tooltip" title=""
                                data-bs-original-title="Default tooltip">
                        </a>
                    </div>


                    <div class="img-item col test  " data-toggle="tooltip" data-bs-html="true"
                        title="<h4> title</h4> <h6> 1200 </h6>">
                        <a href="#">
                            <img src="images/BigRep_One.4-removebg-preview.png" alt="shoe image">
                            <div class="tooltip bs-tooltip-top" role="tooltip">
                                <div class="tooltip-arrow"></div>
                                <div class="tooltip-inner">
                                    Some tooltip text!
                                </div>
                            </div>
                        </a>
                    </div>
                </div> --}}
            </div>

        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });

        function increaseCount(a, b) {
            var input = b.previousElementSibling;
            var value = parseInt(input.value, 10);
            value = isNaN(value) ? 0 : value;
            value++;
            input.value = value;
        }

        function decreaseCount(a, b) {
            var input = b.nextElementSibling;
            var value = parseInt(input.value, 10);
            if (value > 1) {
                value = isNaN(value) ? 0 : value;
                value--;
                input.value = value;
            }
        }




        const imgs = document.querySelectorAll('.img-select a');
        const imgBtns = [...imgs];
        let imgId = 1;

        imgBtns.forEach((imgItem) => {
            imgItem.addEventListener('click', (event) => {
                event.preventDefault();
                imgId = imgItem.dataset.id;
                slideImage();
            });
        });

        function slideImage() {
            const displayWidth = document.querySelector('.img-showcase img:first-child').clientWidth;

            document.querySelector('.img-showcase').style.transform = `translateX(${- (imgId - 1) * displayWidth}px)`;
        }

        window.addEventListener('resize', slideImage);
    </script>


    <section class="mt-5 wow fadeInUp shop " style="margin-bottom: 8rem;  " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container  ">


            <div class="row ">

                <div class="col-lg-8 mb-lg-0 mb-5">

                    <h2 style="color: #2C113E;">{{ __('Description') }}</h2>
                    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                        {!! $product->big_description_ar !!}
                    @else
                        {!! $product->big_description_en !!}
                    @endif

                </div>
                <div class="col-lg-4">
                    <div class=" pb-4 pt-3 px-0 text-center" style="background-color: #FAFAFA; max-width: 300px;">

                        <h4 class="mt-3" style="color: #2C113E;">{{ __('Features & Benefits') }}
                        </h4>


                        <div class="my-4 ">
                            @foreach ($product->benefit as $benefit)
                                <p class=" p-ball wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s"
                                    style="color: #716F72;">
                                    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                        {{ $benefit->title_ar }}
                                    @else
                                        {{ $benefit->title_en }}
                                    @endif
                                </p>
                            @endforeach
                        </div>
                    </div>
                    @if ($product->file)
                        <a href="{{ asset('storage/' . $product->file) }}" target="_blank">
                            <div class="info-box d-flex  justify-content-center align-items-center">
                                <i class="bi bi-filetype-pdf fs-2 me-3"></i>
                                <h6>{{ __('Information Sheet') }}</h6>
                            </div>
                        </a>
                    @endif

                </div>
            </div>

        </div>
    </section>

    @if ($product->link)
        <section class="mt-5 wow fadeInUp shop " style="margin-bottom: 8rem;  " data-wow-duration="2s" data-wow-delay=".5s">
            <div class="container border-1  border-bottom " style="padding-bottom: 6rem;  ">
                <div class="text-start " style="margin-bottom: 3rem; ">
                    <h1 style="color: #2C113E;">{{ __('Product Videos:') }}</h1>
                </div>
                <div style="height: 400px;">
                    <iframe style="width: 80%; height: 100%;"
                        src="https://www.youtube.com/embed/{{ $product->getIdYoutube() }}" title="YouTube video player"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
                </div>
            </div>
        </section>
    @endif


    <section class="my-5 wow fadeInUp shop " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container">
            <div class="text-start " style="margin-bottom: 7rem;">
                <h1 style="color: #2C113E;">{{ __('Recommended') }}</h1>
            </div>
            <div class=" row   prod">
                @foreach (App\Models\Product::where('id','<>',$product->id)->latest()->take(3)->get() as $item)
                    <div style="margin-bottom: 5rem;" class="col-lg-4 col-md-6  px-4 wow fadeInUp  " data-wow-duration="2s"
                        data-wow-delay=".5s">
                        <a href="{{ route('view.product', $item->id) }}"> <img src="{{ asset('storage/'.$item->main_image) }}" class="img-fluid w-100"
                                style="background-color: #F2F4F4;" alt=""></a>
                        <h4 class="prg2 mt-5" style="color: #2C113E;">
                            @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $item->name_ar }}
                            @else
                                {{ $item->name_en }}
                            @endif
                        </h4>
                        <p class="p prg2 mt-4 mb-5" style="line-height: 25px; color: #716F72;">
                            @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ Str::limit($item->short_description_ar, 600, '...') }}
                            @else
                                {{ Str::limit($item->short_description_en, 600, '...') }}
                            @endif
                        </p>

                        <a class=" btn btn-top rounded-3 shadow shadow-sm fs-5" href="{{ route('view.product', $item->id) }}" style="padding: 11px 4rem;">{{ __('Read More') }} </a>

                    </div>
                @endforeach
            </div>
        </div>
    </section>


    <section class="cstumer my-5 pt-3" data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container">
            <div class="row align-items-center py-5">
                <div class="col-lg-3 col-md-5 text-start mb-5 wow fadeInLeftBig">
                    <p class="cs-p mt-0 " style="opacity: 70%;">{{ __('We are proud of you') }}</p>
                    <p class="cs-h3 mt-0">{{ __('Our custumer') }}</p>
                    <p class="mt-4 prg">
                        Lorem Ipsum is simply dummy text of the
                        printing and typesetting industry. Lorem
                        Ipsum industry's standard
                    </p>


                </div>
                <div class="col-lg-9  col-md-7 text-end  mb-5 wow fadeInRightBig">
                    <div class="swiper mySwiper">
                        <div class="swiper-wrapper">
                            @foreach (App\Models\Client::get() as $client)
                            <div class="swiper-slide text-center border border-1 rounded-3 py-4">
                                <img src="{{ asset('storage/'.$client->image) }}" width="130" height="130" alt="@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $client->name_ar }} @else {{ $client->name }} @endif">
                            </div>
                            @endforeach
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@stop
