@extends('front.layout.pages')
@section('title')
    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $page->title_ar }}
    @else
        {{ $page->title }}
    @endif
@stop
@section('content')

<section class="land-sec position-relative   wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s" style="overflow-y: hidden;">
    <div class="container text-center text-md-start">
        <div class="row  align-items-center justify-content-center ">
            <div class="col-xl-6 col-lg-7 text-white  mb-4 wow fadeInLeft"  data-wow-duration="2s" data-wow-delay=".5s">
                    <h5 class="  mb-3">
                        {{ __('Hardware') }}
                    </h5>
                    <h1 class="mb-3 fw-bold" style="font-size: 50px;">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $page->title_ar ?? 'ثري دي لخدمات الطباعة' }}
                        @else
                            {{ $page->title ?? '3D Printing' }}
                        @endif
                    </h1>
                        <p class="mb-lg-5 prg">
                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $page->sub_title_ar }}
                            @else
                                {{ $page->sub_title}}
                            @endif
                        </p>
                        <a data-bs-toggle="modal" data-bs-target="#exampleModal1" class="btn btn-top  rounded-3 shadow shadow-sm fs-4" style="padding: 11px 4rem;">
                            {{ __('Get a Quote') }}
                        </a>

            </div>
            <div class="col-5  mb-4 wow"  data-wow-duration="2s" data-wow-delay=".5s">
                <img src="{{ asset('storage/'.$page->header_image) }}" class="position-absolute" width="504"   alt="">
            </div>
        </div>
    </div>
</section>

@if((count($page->features) != 0 && $page->feature_title_ar && $page->feature_sub_title_ar) || (count($page->features) != 0 && $page->feature_title && $page->feature_sub_title))
<section class="Features  wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
    <div class="container">
        <div class="top-div wow fadeInLeft " data-wow-duration="2s" data-wow-delay=".5s">
            <h5 class="top-title mb-4">
                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                    {{ $page->feature_sub_title_ar ?? $page->feature_sub_title }}
                @else
                    {{ $page->feature_sub_title ?? $page->feature_sub_title_ar }}
                @endif
            </h5>
            <h1>
                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                    {{ $page->feature_title_ar ?? $page->feature_title }}
                @else
                    {{ $page->feature_title ?? $page->feature_title_ar}}
                @endif
            </h1>
        </div>
        <div class="row text-center">
            @foreach ($page->features as $feature)
                <div class="col-lg-3 col-sm-6 mb-3 ">
                    <img src="{{ asset('storage/'.$feature->image) }}" class="mb-5" alt="">
                    <h4 class="mb-3 prg1">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $feature->title_ar }}
                        @else
                            {{ $feature->title}}
                        @endif
                    </h4>
                    <p class="prg1">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $feature->description_ar }}
                        @else
                            {{ $feature->description}}
                        @endif
                    </p>
                </div>
            @endforeach
        </div>
    </div>

</section>
@endif

@if((count($page->themes) != 0 && $page->theme_title_ar && $page->theme_sub_title_ar) || (count($page->themes) != 0 && $page->theme_title && $page->theme_sub_title))
    <section class="sectitle wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center">
            <div class="row text-center">
                <div class="col-lg-7 mx-auto">
                    <h2>
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $page->theme_title_ar ?? $page->theme_title}}
                        @else
                            {{ $page->theme_title ?? $page->theme_title_ar}}
                        @endif
                    </h2>
                    <p>
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $page->feature_sub_title_ar ?? $page->feature_sub_title }}
                        @else
                            {{ $page->feature_sub_title ?? $page->feature_sub_title_ar}}
                        @endif
                    </p>
                </div>
            </div>
        </div>
    </section>
    @foreach($page->themes as $key => $theme)
        <section class="what-do  ">
            <div class="container">
                <div class="row justify-content-between">
                    @if(($key % 2) == 0)
                        <div class="col-lg-5  mb-3 wow fadeInLeft"  data-wow-duration="2s" data-wow-delay=".5s">
                            <h5 class="top-title mb-3">
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $theme->sub_title_ar }}
                                @else
                                    {{ $theme->sub_title }}
                                @endif
                            </h5>
                            <h2 class="mb-5">
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $theme->title_ar }}
                                @else
                                    {{ $theme->title }}
                                @endif
                            </h2>
                            <p class="p prg">
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $theme->description_ar }}
                                @else
                                    {{ $theme->description }}
                                @endif
                            </p>
                            <a data-bs-toggle="modal" data-bs-target="#exampleModal1" class="btn btn-top  rounded-3 shadow shadow-sm fs-4" style="padding: 11px 4rem;">
                                {{ __('Get a Quote') }}
                            </a>
                        </div>
                        <div class="col-lg-5 mb-3 wow fadeInRight"  data-wow-duration="2s" data-wow-delay=".5s">
                            <img src="{{ asset('storage/'.$theme->image) }}" class="img-fluid"  alt="">
                        </div>
                    @else
                        <div class="col-lg-5 mb-3 wow fadeInLeft"  data-wow-duration="2s" data-wow-delay=".5s">
                            <img src="{{ asset('storage/'.$theme->image) }}" class="img-fluid"  alt="">
                        </div>
                        <div class="col-lg-5  mb-3 wow fadeInRight"  data-wow-duration="2s" data-wow-delay=".5s">
                            <h5 class="top-title mb-3">
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $theme->sub_title_ar }}
                                @else
                                    {{ $theme->sub_title }}
                                @endif
                            </h5>
                            <h2 class="mb-5">
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $theme->title_ar }}
                                @else
                                    {{ $theme->title }}
                                @endif
                            </h2>
                            <p class="p prg">
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    {{ $theme->description_ar }}
                                @else
                                    {{ $theme->description }}
                                @endif
                            </p>
                            <a data-bs-toggle="modal" data-bs-target="#exampleModal1" class="btn btn-top  rounded-3 shadow shadow-sm fs-4" style="padding: 11px 4rem;">
                                {{ __('Get a Quote') }}
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </section>
    @endforeach
@endif

<section class="cstumer mt-5 pt-3" >
    <div class="container">
        <div class="row align-items-center py-5">
            <div class="col-lg-3 col-md-5 text-start mb-5 wow fadeInLeft" data-wow-duration="2s" data-wow-delay=".5s">
                <p class="cs-p mt-0 " style="opacity: 70%;">{{ __('We are proud of you') }}</p>
                <p class="cs-h3 mt-0">{{ __('Our custumer') }}</p>
                <p class="mt-4 prg">
                    Lorem Ipsum is simply dummy text of the
                    printing and typesetting industry. Lorem
                    Ipsum industry's standard
                </p>
            </div>
            <div class="col-lg-9  col-md-7 text-end  mb-5 wow fadeInRight" data-wow-duration="2s" data-wow-delay=".5s">
                <div class="swiper mySwiper">
                    <div class="swiper-wrapper">
                        @foreach (App\Models\Client::get() as $client)
                        <div class="swiper-slide text-center border border-1 rounded-3  py-4">
                            <img src="{{ asset('storage/'.$client->image) }} " width="130" height="130" alt="@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $client->name_ar }} @else {{ $client->name }} @endif">
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


@stop
