{{-- @dd(Mcamara\LaravelLocalization\Facades\LaravelLocalization::setLocale()) --}}
@php
    $setting = App\Models\Websit::first();
@endphp
<!DOCTYPE html>
<html @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') lang="ar" @else lang="en" @endif style="height: 100%; width: 100%;">

<head @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') dir="rtl" @endif>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $setting->websit_title_ar ?? 'ثري دي لخدمات الطباعة' }} @else {{ $setting->websit_title ?? '3D Printing' }} @endif | @yield('title')</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">

    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
    <link rel="stylesheet" href="{{ asset('front/css/index ar.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.rtl.min.css" integrity="sha384-gXt9imSW0VcJVHezoNQsP+TNrjYXoGcrqBZJpry9zJt8PCQjobwmhMGaDHTASo9N" crossorigin="anonymous">    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.css" />
    @else
    <link rel="stylesheet" href="{{ asset('front/css/index.css') }}">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

    @endif
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.css" />
    <link rel="stylesheet" href="{{ asset('front/css/animate.css') }}">


    <link rel="apple-touch-icon" href="{{ asset('storage/' . ($setting->favicon_image ?? 'app-assets/images/ico/apple-icon-120.png')) }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('storage/' . ($setting->favicon_image ?? 'app-assets/images/ico/apple-icon-120.png')) }}">

</head>

<body @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') dir="rtl" @endif style="height: 100%; width: 100%; position: relative;" class="wow fadeInUp " data-wow-duration="2s"
    data-wow-delay=".5s">
    <x-alert-modal />
    <script>
        window.onload = function WindowLoad(event) {
            $('#alertModal').modal('toggle');
        }
    </script>
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog w-25 mx-auto ">
            <div class="modal-content">
                <div class="modal-body ">
                    <div class="d-flex  align-items-center  justify-content-evenly ">
                        <i class="bi bi-grid-fill fs-3 me-5 gr-co d-none  " style=" "></i>
                        <a href="#" class="" data-bs-toggle="modal" data-bs-target="#exampleModal2">
                            <div class="fw-bold" style="color: #481968; font-size: 20px !important;">
                                <i class="bi bi-search"></i>
                            </div>
                        </a>
                        <div>
                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                <a href="{{ LaravelLocalization::getLocalizedURL('en', null, [], true) }}" hreflang="en" class="lang " style="color: #481968 !important;">EN</a>
                            @else
                                <a href="{{ LaravelLocalization::getLocalizedURL('ar', null, [], true) }}" hreflang="en" class="lang " style="color: #481968 !important;">AR</a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exampleModal1" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <form action="{{ route('view.contact') }}" id="contactForm" method="POST">
                        @csrf
                        <div class="container text-center">
                            <div class="mt-2 mb-4 border-1 border-bottom py-3">
                                <h2 style="color: var(--color1);" class="fw-bold">{{ __('Get a Quote') }}</h2>
                            </div>
                            <div class="row text-start my-5">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">{{ __('Name') }}</label>
                                        <input type="text" class="form-control shadow-none" name="name" id="name"
                                            aria-describedby="emailHelp">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="exampleInputEmail1" class="form-label">{{ __('Email address') }}</label>
                                        <input type="email" class="form-control shadow-none" name="email" id="email"
                                            aria-describedby="emailHelp">

                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="exampleInputPassword1" class="form-label">{{ __('Phone No') }}</label>
                                        <input type="text " class="form-control shadow-none" name="phone"
                                            id="phone">
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="exampleInputPassword1" class="form-label">{{ __('Address') }}</label>
                                        <input type="texr " class="form-control shadow-none" name="subject"
                                            id="subject">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label for="exampleInputPassword1" class="form-label">{{ __('Description') }}</label>
                                        <textarea rows="5" class="form-control shadow-none" name="message" id="message"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-3">
                                    <div class="h-captcha my-0" data-sitekey="194e8efb-f32d-4d44-8ffb-b54694c2f321">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-center mb-4 ">
                            <button type="submit" class="btn btn-top1 py-3 rounded-3 shadow shadow-sm fs-4"
                                style="padding: 0 5rem;" id="contact_submit" onclick="submitContact()">{{ __('Submit') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade " style="background-color: rgba(0, 0, 0, 0.582);" id="exampleModal2" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <button type="button" class="btn-close shadow-none mt-0 position-absolute bg-white fs-2"
            style="left: 70%; top: 8%;"data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="modal-dialog   modal-dialog-centered ">
            <div class="modal-content  " style="background-color: transparent; border: 0px;">
                <div class="modal-body   ">
                    <form>
                        <div class="container  mx-auto text-center">
                            <div class="row my-5 ">
                                <div class="input-group mb-3 mx-auto">
                                    <input type="text" class="form-control py-4 px-5 mx-auto shadow-none "
                                        style="background-color :white ; border : 0px; border-radius: 0px; "
                                        placeholder="Type something to search..." aria-label="Recipient's username"
                                        aria-describedby="basic-addon2">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary py-4 px-5 shadow-none"
                                            style="background-color :#481968 ; border : 0px; color: white; border-radius: 0px;  "
                                            type="submit">{{ __('Search') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="offcanvas offcanvas-start" style="transition: all 2s .2s;" tabindex="-1" id="offcanvasRight"
        aria-labelledby="offcanvasExampleLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasExampleLabel">
                <a href="{{ route('view.index') }}"> <img src="{{ asset('storage/'.$setting->logo) }}" alt=""></a>
            </h5>
            <button type="button" class="btn-close text-reset shadow-none" data-bs-dismiss="offcanvas"
                aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <nav class="sidebar card py-2 mb-4">
                <ul class="nav flex-column" id="nav_accordion">
                    <li class="nav-item has-submenu ">
                        <a class="nav-link d-flex align-items-center justify-content-between" onclick="myFunction1()"
                            href="#"> 3D Printing & Designing
                            <i id="cli" class="bi bi-caret-down-fill"></i>
                        </a>
                        <ul class="submenu collapse">
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item has-submenu ">
                        <a class="nav-link d-flex align-items-center justify-content-between" onclick="myFunction1()"
                            href="#"> 3dit shop
                            <i id="cli" class="bi bi-caret-down-fill"></i>
                        </a>
                        <ul class="submenu collapse">
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item has-submenu ">
                        <a class="nav-link d-flex align-items-center justify-content-between" onclick="myFunction1()"
                            href="#"> About
                            <i id="cli" class="bi bi-caret-down-fill"></i>
                        </a>
                        <ul class="submenu collapse">
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item has-submenu ">
                        <a class="nav-link d-flex align-items-center justify-content-between" onclick="myFunction1()"
                            href="#"> Resources
                            <i id="cli" class="bi bi-caret-down-fill"></i>
                        </a>
                        <ul class="submenu collapse">
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                            <li class="nav-item ">
                                <a class="nav-link me-2" href="#">w1</a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </nav>
        </div>
    </div>


    <section class="section1 position-relative d-flex justify-content-center  ">
        <div class="container position-absolute  " style="z-index: 10; top: 20px ;">
            <nav class="navbar navbar-expand-lg navbar-light ">
                <div class=" container-fluid  ">
                    <a class=" navbar-brand text-start " href="{{ route('view.index') }}"> <img class=""
                            src="{{ asset('storage/'.$setting->logo) }}" width="250" alt=""></a>
                    <button class="  navbar-toggler  border-0 " style="color: #481968 !important;" type="button"
                        data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <i class=" bi bi-list fs-1 "></i>
                    </button>
                    <button class="  navbar-toggler r border-0 " type="button"
                        data-bs-toggle="modal" data-bs-target="#exampleModal" aria-expanded="false"
                        aria-label="Toggle navigation">
                        <i class=" bi bi-three-dots fs-1 "></i>
                    </button>

                    <div class="collapse navbar-collapse justify-content-between" id="navbarSupportedContent">
                        <ul class="navbar-nav hov  mb-2 mb-lg-0 n" style="gap: 5px;">
                            @foreach (App\Models\Menu::where('status','1')->get() as $item)
                                @if($item->id != 2)
                                    <li class="nav-item dropdow ">
                                        <div class="dropbtn nav-link d-flex">
                                        <a  aria-current="page" href="javascript:;"> @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $item->name_ar }} @else {{ $item->name }} @endif</a>
                                            @if(count($item->pages) != 0 || $item->id == 3) <i class="bi bi-chevron-down  ms-1 pt-2 text-dark fw-bold"></i> @endif
                                        </div>
                                        <div class="dropdow-content">
                                            @if($item->id == 3)
                                                <a href="{{ route('view.about') }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') من نحن @else Who We Are @endif</a>
                                            @endif
                                            @if(count($item->pages) != 0)
                                                @foreach ($item->pages as $page)
                                                    <a href="{{ route('view.page', $page->id) }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $page->title_ar }} @else {{ $page->title }} @endif</a>
                                                @endforeach
                                            @endif
                                        </div>
                                    </li>
                                @else
                                    <li class="nav-item dropdow ">
                                        <div class="dropbtn nav-link  d-flex">
                                            <a  aria-current="page" href="javascript:;"> @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $item->name_ar }} @else {{ $item->name }} @endif
                                            </a>
                                            @if(count(App\Models\Category::get()) != 0) <i class="bi bi-chevron-down  ms-1 pt-2 text-dark fw-bold"></i> @endif
                                        </div>
                                        @if(count(App\Models\Category::get()) != 0)
                                            <div class="dropdow-content py-3 pe-2 text-start" style="min-width: 600px; left: -120px;">
                                                <div class="container">
                                                    <div class="row">
                                                        @foreach (App\Models\Category::get() as $category)
                                                            <div class="col-4">
                                                                <h5 class="mb-2 ps-3">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $category->name_ar }} @else {{ $category->name_en }} @endif</h5>
                                                                @foreach($category->subCategories as $sub)
                                                                    <a href="{{ route('view.products',$sub->id) }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')  {{ $sub->name_ar }} @else {{ $sub->name }} @endif</a>
                                                                @endforeach
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                        <div class="d-flex  align-items-center  justify-content-start mar ">
                            <i class="bi bi-grid-fill fs-3 me-5 gr-co d-none  " style=" "></i>
                            <a href="#" class="" data-bs-toggle="modal" data-bs-target="#exampleModal2">
                                <div class=" scer me-3  text-center rounded-circle "
                                >
                            <i class="bi bi-search"></i>
                            </div> </a>

                            <div>
                                @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                    <a href="{{ LaravelLocalization::getLocalizedURL('en', null, [], true) }}" hreflang="en" class="lang ">EN</a>
                                @else
                                    <a href="{{ LaravelLocalization::getLocalizedURL('ar', null, [], true) }}" hreflang="en" class="lang ">AR</a>
                                @endif
                            </div>

                        </div>
                    </div>
                </div>
            </nav>
        </div>

        <!-- slider -->
        <div class=" bg h-100 w-100 pb-5 position-relative ">
            @yield('slider')

            <div class="d-flex d-none  align-items-center justify-content-end">
                <h5 id="bu" class="px-3  " style="background-color: var(--color2); color: white; padding: 1.7rem 0;">
                3D printing
                </h5>
                <img class="px-3 imf-fluid  bg-white " src="{{ asset('front/images/Untitled-3.png') }}" alt="">
            </div>

        </div>
        <!-- ./slider -->
    </section>

    @yield('content')


    <footer class="wow fadeInUp" data-wow-duration="2s" data-wow-delay=".5s">
        <div class="footer-lists text-white">
            <div class="container ">
                <div class="row py-5 align-items-center text-lg-start text-center">
                    <div class="col-lg-3 col-md-6 col-12 mb-4">
                        <img src="{{ asset('storage/'.($setting->white_logo ?? $setting->logo   )) }}" class="img-fluid" alt="">
                    </div>

                    <div class="col-lg-3 col-sm-6 col-12 mb-4">
                        <p class="fs mb-lg-5 mb-3 mt-3 ps-0">{{ __('About US') }}</p>
                        <ul class="nav  flex-column">
                            <li class="  nav-item">
                                <a class=" nav-link ps-0 text-white" href="{{ route('view.about') }}">{{ __('Who We Are') }}</a>
                            </li>
                            <li class="  nav-item">
                                <a class="nav-link ps-0 text-white" href="{{ route('view.press') }}">{{ __('Press') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link ps-0 text-white " href="{{ route('view.blogs') }}">{{ __('Blog') }}</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12 mb-4">
                        <p class="fs mb-lg-5 mb-3 mt-3 ps-0">{{ __('Quic Links') }}</p>
                        <ul class="nav  flex-column">
                            <li class="  nav-item">
                                <a class=" nav-link ps-0 text-white" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal1">{{ __('Get a Quote') }}</a>
                            </li>
                            <li class="  nav-item">
                                <a class="nav-link ps-0 text-white" href="{{ route('view.contact') }}">{{ __('Contact Us') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link ps-0 text-white " href="{{ route('view.study-cases') }}">{{ __('Case Studies') }}</a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-sm-6 col-12 mb-4">
                        <p class="fs mb-lg-5 mb-3 mt-3 ps-0">{{ __('Contact Info') }}</p>
                        <ul class="nav  flex-column">
                            <li class="  nav-item">
                                <a class=" nav-link ps-4  text-white" href="javascript:;">
                                    <i class="bi bi-phone fs-6 me-2"></i> <span>{{ $setting->phone }}</span>
                                </a>
                            </li>
                            <li class="  nav-item">
                                <a class=" nav-link ps-4 text-white" href="javascript:;">
                                    <i class="bi bi-envelope fs-6 me-2"></i> <span>{{ $setting->email }}</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <div class=" socil-icon ps-3 justify-content-lg-start justify-content-center text-white d-flex">
                                    @if($setting->facebook)
                                    <a class="me-3" href="{{ $setting->facebook }}">
                                        <i class="bi bi-facebook  "></i>
                                    </a>
                                    @endif
                                    @if($setting->twitter)
                                    <a class="me-3" href="{{ $setting->twitter }}">
                                        <i class="bi bi-twitter  "></i>
                                    </a>
                                    @endif
                                    @if($setting->instagram)
                                    <a class="me-3" href="{{ $setting->instagram }}">
                                        <i class="bi bi-instagram  "></i>
                                    </a>
                                    @endif
                                    @if($setting->youtube)
                                    <a class="" href="{{ $setting->youtube }}">
                                        <i class="bi bi-youtube  "></i>
                                    </a>
                                    @endif
                                </div>
                            </li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
        <div class="">
            <div class="container mt-lg-0 mt-2">
                <div class="row  align-items-center  ">
                    <div
                        class="col-lg-6 my-2 d-flex  align-items-center justify-content-center justify-content-lg-start ">
                        <p class="my-2 me-3">{{ __('Powered By') }} </p>
                        <img src="{{ asset('front/images/websoft-logo-small.png') }}" alt="">

                    </div>
                    <div class="col-lg-6  my-2 text-lg-end text-center right-p">
                        <p>{{ __('All Right Reserved For 3DIT @ 2022') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src='https://js.hcaptcha.com/1/api.js'></script>

    <script src="{{ asset('front/js/wow.min.js') }}"></script>
    <script>
        new WOW().init();
    </script>
    <script src="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.js"></script>

    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha384-tsQFqpEReu7ZLhBV2VZlAu7zcOV+rXbYlF2cqB8txI/8aZajjp4Bqd+V6D5IgvKT" crossorigin="anonymous">
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>

    <script src="{{ asset('front/js/index.js') }}"></script>
    <script>
        function submitContact(){
            document.getElementById("contact_submit").disabled = true;
            document.getElementById("contactForm").submit();
        }
    </script>

@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
    <script>
        $num = $('.my-card').length;
        $even = $num / 2;
        $odd = ($num + 1) / 2;

        if ($num % 2 == 0) {
            $('.my-card:nth-child(' + $even + ')').addClass('active1');
            $('.my-card:nth-child(' + $even + ')').prev().addClass('prev');
            $('.my-card:nth-child(' + $even + ')').next().addClass('next');
        } else {
            $('.my-card:nth-child(' + $odd + ')').addClass('active1');
            $('.my-card:nth-child(' + $odd + ')').prev().addClass('prev');
            $('.my-card:nth-child(' + $odd + ')').next().addClass('next');
        }
        $('.my-card').click(function () {
            $slide = $('.active1').width();
            console.log($('.active1').position().right);

            if ($(this).hasClass('next')) {
                $('.card-carousel').stop(false, true).animate({ right: '-=' + $slide });
            } else if ($(this).hasClass('prev')) {
                $('.card-carousel').stop(false, true).animate({ right: '+=' + $slide });
            }

            $(this).removeClass('prev next');
            $(this).siblings().removeClass('prev active1 next');

            $(this).addClass('active1');
            $(this).prev().addClass('prev');
            $(this).next().addClass('next');
        });
    </script>
@endif
</body>

</html>
