@extends('front.layout.app')

@section('title')
    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        الصفحة الرئيسية
    @else
        Main Page
    @endif
@stop

@section('slider')
    <div class="container" style="margin-top: 12rem;">
        <div id="carouselExampleCaptions2" class="carousel slide topcor" data-bs-ride="carousel">
            <div class="carousel-indicators     " >


                <div style="position: relative;" class=" d-flex align-items-center">
                    @foreach (App\Models\Slider::latest()->take(4)->get() as $key => $slider)
                        <div data-bs-target="#carouselExampleCaptions2" class="w-balltop ms-3 @if($loop->first) active @endif" data-bs-slide-to="{{ $key }}"
                        aria-current="true" aria-label="Slide {{ $key }}"></div>
                    @endforeach
                </div>

            </div>

            <div  class="carousel-inner" >
                @foreach (App\Models\Slider::latest()->take(4)->get() as $key => $slider)
                    <div class="carousel-item @if($loop->first) active @endif">
                        <div class="container sa">
                            <div class="row align-items-center justify-content-center">
                                <div class="col-lg-7 mb-lg-0  mb-5">
                                    @php
                                        if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                            $sliderTitle = explode(' ',$slider->title_ar);
                                        else
                                            $sliderTitle = explode(' ',$slider->title);
                                    @endphp

                                    <h1 class="mb-2 mov-s" style="color: var(--color1); font-size: 60px;" >{{ $sliderTitle[0] . ' ' . $sliderTitle[1] }} <span
                                        style="color: var(--color2);">@for($i = 2; $i < count($sliderTitle); $i++) {{ $sliderTitle[$i] . ' ' }} @endfor</span>
                                    </h1>
                                    <h4 class="mb-4 "> @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $slider->sub_title_ar }} @else {{ $slider->sub_title }} @endif </h4>
                                    <p class="mb-5 ">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $slider->description_ar }} @else {{ $slider->description }} @endif</p>

                                    <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModal1" class="btn btn-top  rounded-3 shadow shadow-sm fs-4" style="padding: 11px 4rem;">{{ __('Get a Quote') }}</a>
                                </div>
                                <div class="col-lg-5  text-end pe-0" style="">
                                    <img src="{{ asset('storage/'.$slider->image) }}" class="img-fluid"  alt="">

                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="position-absolute" style="z-index: -1; @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') left: 650px; transform: rotateY(180deg); @else right: 650px; @endif top: 50px; overflow-x: hidden; filter: grayscale(100%);"><img src="{{ asset('front/images/1.png') }}" alt=""></div>
        </div>
    </div>
@stop


@section('content')
<section class="sl wow fadeInUp mb-5 " data-wow-duration="2s" data-wow-delay=".3s" style="">
    <div class="swiper mySwiper1 w-50 justify-content-center d-flex align-items-center" >
        <div class="swiper-wrapper">
            @foreach (App\Models\Partner::get() as $partner)
                <div class="swiper-slide" >
                    <img src="{{ asset('storage/'.$partner->image) }}" class="img-fluid flit"
                    alt="@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'){{ $partner->name_ar }}@else{{ $partner->name }}@endif"
                    title="@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'){{ $partner->name_ar }}@else{{ $partner->name }}@endif">
                </div>
            @endforeach
        </div>

    </div>
</section>



<section class="futs my-5 wow fadeInUp " data-wow-duration="2s" data-wow-delay=".7s">
    <div class="container text-center">
        <p class="cs-p mt-5 mb-0  ">{{ __('Best 3D Printing Serevices') }}</p>
        <p class="cs-h3  mt-0 ">{{ __('what we offer') }}</p>
        <div class="row   text-start" style="margin-top: 6rem;">
            @foreach (App\Models\Service::get() as $service)
                <div class="col-lg-1 col-md-2 col-3 mb-5">
                    <img src="{{ asset('storage/'.$service->image) }}" class="img-fluid" alt="">
                </div>
                <div class="col-lg-3 col-md-4 col-9 mb-5">
                    <h4 class="fw-bolder">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $service->name_ar }}
                        @else
                            {{ $service->name }}
                        @endif
                    </h4>
                    <p class="mt-3 mb-5 prg" style="font-size: 15px;">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $service->description_ar }}
                        @else
                            {{ $service->description }}
                        @endif
                    </p>
                    <a href="#" class="card-link">{{ __('Discover Details') }} <i class=" ms-3 bi @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') bi-arrow-left @else bi-arrow-right @endif rmo-ico"></i> </a>
                </div>
            @endforeach
        </div>
    </div>
</section>

<section class="sec3 cor wow fadeInUp   " data-wow-duration="2s" data-wow-delay=".7s">

    <div class="bg-new h-100 ">

        <div id="carouselExampleCaptions" class="carousel slide  " style="" data-bs-ride="false">
            <div class="carousel-indicators d-flex align-items-center position-relative of-lo">
                @foreach(App\Models\Step::get() as $key => $step)
                    @if(!$loop->first)<div class="w-tall"></div>@endif
                    <div data-bs-target="#carouselExampleCaptions" class="w-ball @if($loop->first) active @endif" data-bs-slide-to="{{ $key }}"
                        aria-label="Slide {{ $key+1 }}"><span class="w-ballsp d-none">{{ $key+1 }}</span> </div>
                @endforeach
            </div>

            <div class="carousel-inner  text-white mm slidp ">
                @foreach(App\Models\Step::get() as $key => $step)
                <div class="carousel-item  @if($loop->first) active @endif">
                    <div class="container mx-auto">
                        <div class="row align-items-center justify-content-center">
                            <div class="col-lg-5">
                                <p style="color: #BBA6CA;">{{ __('How it works') }}</p>
                                <h1 class="mb-4">
                                    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                        {{ $step->title_ar }}
                                    @else
                                        {{ $step->title }}
                                    @endif
                                </h1>
                                <p>
                                    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                        {{ $step->description_ar }}
                                    @else
                                        {{ $step->description }}
                                    @endif
                                </p>
                            </div>
                            <div class="col-lg-7  mrg">
                                <img src="{{ asset('storage/'.$step->image) }}" class="size imgm" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

            </div>


        </div>
    </div>


</section>



<section class="product mb-5 ">
    <div class="container text-center wow fadeInUp " data-wow-duration="2s" data-wow-delay=".7s">

        <p class="cs-p mt-5 mb-0  ">{{ __('Best 3dprinting product') }}</p>
        <p class="cs-h3 mt-0 ">{{ __('Our Last Products') }}</p>
        <div class="row justify-content-center">
            <ul class="nav my-4 nav-pills mb-3 d-flex justify-content-center" id="pills-tab" role="tablist">

                @foreach (App\Models\SubCategory::latest()->take(10)->get() as $sub)
                    <li class="nav-item" role="presentation">
                        <button class="nav-link mb-3 @if($loop->first) active @endif" id="{{ $sub->id }}-tab" data-bs-toggle="pill"
                            data-bs-target="#pills-{{ $sub->id }}" type="button" role="tab" aria-controls="pills-{{ $sub->id }}"
                            aria-selected="@if($loop->first) true @else false @endif">
                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $sub->name_ar }}
                            @else
                                {{ $sub->name }}
                            @endif
                        </button>
                    </li>
                @endforeach

            </ul>
            <div class="tab-content wow " id="pills-tabContent">
                @foreach (App\Models\SubCategory::latest()->take(10)->get() as $sub)
                <div class="tab-pane fade @if($loop->first) show active @endif" id="pills-{{ $sub->id }}" role="tabpanel"
                    aria-labelledby="{{ $sub->id }}-tab">
                    <div class="row mt-5 justify-content-center">
                        @foreach ($sub->products()->latest()->take(8)->get() as $product)
                        <div class="col-xl-3 col-md-4 col-6 c-12 mb-3 wow fadeInUp  " data-wow-duration="2s"
                            data-wow-delay=".5s">
                            <div class=" border border-1  p-3  pb-5  br-rd">
                                <a href="{{ route('view.product', $product->id) }}">
                                    <img src="{{ asset('storage/'.$product->main_image) }}" class="img-fluid " alt="">
                                </a>
                                <h5 class="mt-4" style="font-size: 1.2rem !important;">
                                    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                        {{ $product->name_ar }}
                                    @else
                                        {{ $product->name_en }}
                                    @endif
                                </h5>

                            </div>
                        </div>
                        @endforeach
                    </div>

                    <div class="" style="margin: 6rem 0 5rem ;">
                        <a href="{{ route('view.products',$sub->id) }}" class="btn btn-outline-info py-3 shadow shadow-sm"
                            style="padding: 0 5rem;">{{ __('Discover More') }}</a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>


<section class="tre-bg py-5 wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
    <div class="container-fluid overflow-hidden text-center">
        <p class="cs-p mt-5">{{ __('We are proud of you') }}</p>
        <p class="cs-h3 mt-0">{{ __('Testimonials') }}</p>
        <div class="container text-center my-5  add-sect">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-sm-10 col-12 d-flex ">
                    <div class="swiper mySwiper2">
                        <div class="swiper-wrapper">
                            @foreach(App\Models\ClientOpinion::get() as $opinion)
                            <div class="swiper-slide d-flex justify-content-center ">
                                <div class="d-flex flex-column ">
                                    <i class="bi bi-pause-fill  ms-3 mt-2 "></i>
                                </div>
                                <div class="d-flex flex-column ms-2  " style="margin-top: 3rem;">
                                        <h4 class="text-start d-n" style="font-size: 1rem;">
                                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ Str::limit($opinion->message_ar,250) }}
                                            @else
                                                {{ Str::limit($opinion->message,250) }}
                                            @endif
                                        </h4>
                                        <div class="d-flex mt-2">
                                            <span class="bi bi-star-fill checked me-1"></span>
                                            <span class="bi bi-star-fill checked me-1"></span>
                                            <span class="bi bi-star-fill checked me-1"></span>
                                            <span class="bi bi-star-fill checked me-1"></span>
                                            <span class="bi bi-star-fill checked me-1"></span>

                                        </div>
                                        <p class="text-start mt-2" style=" font-size: 20px;">
                                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $opinion->name_ar }}
                                            @else
                                                {{ $opinion->name }}
                                            @endif
                                        </p>
                                        <p class="text-start  " style="font-size:small ;">
                                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                                {{ $opinion->client_position_ar }}
                                            @else
                                                {{ $opinion->client_position }}
                                            @endif
                                        </p>

                                </div>
                                <div class="d-flex flex-column  ">
                                    <i class="bi bi-pause-fill d-n   " style="margin-top: 5.5rem;"></i>
                                </div>

                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-carousel del-sect ">
            <div class="my-card">
              <div class="d-flex">
                <div class="d-flex flex-column ">
                  <i class="bi bi-pause-fill  ms-3 mt-2 "></i>
                </div>
                <div class="d-flex flex-column ms-2  " style="margin-top: 4rem;">
                    <h4 class="text-start d-n" style="font-size: 1rem;">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ Str::limit($opinion->message_ar,100) }}
                        @else
                            {{ Str::limit($opinion->message,100) }}
                        @endif
                    </h4>
                    <div class="d-flex mt-3">
                      <span class="bi bi-star-fill checked me-1"></span>
                      <span class="bi bi-star-fill checked me-1"></span>
                      <span class="bi bi-star-fill checked me-1"></span>
                      <span class="bi bi-star-fill checked me-1"></span>
                      <span class="bi bi-star-fill checked me-1"></span>

                    </div>
                    <p class="text-start mt-2" style=" font-size: 20px;">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $opinion->name_ar }}
                        @else
                            {{ $opinion->name }}
                        @endif
                    </p>
                    <p class="text-start  " style="font-size:small ;">
                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $opinion->client_position_ar }}
                        @else
                            {{ $opinion->client_position }}
                        @endif
                    </p>


                </div>
                <div class="d-flex flex-column  ">
                  <i class="bi bi-pause-fill d-n   " style="margin-top: 5.5rem;"></i>
                </div>
              </div>

            </div>
        </div>
    </div>

</section>

<section class="cstumer my-5" data-wow-duration="2s" data-wow-delay=".5s">
    <div class="container">
        <div class="row align-items-center py-5">
            <div class="col-lg-3 col-md-5 text-start mb-5 wow fadeInLeftBig">
                <p class="cs-p mt-0 " style="opacity: 70%;">{{ __('We are proud of you') }}</p>
                <p class="cs-h3 mt-0">{{ __('Our custumer') }}</p>
                <p class="mt-4 prg">
                    Lorem Ipsum is simply dummy text of the
                    printing and typesetting industry. Lorem
                    Ipsum industry's standard
                </p>


            </div>
            <div class="col-lg-9  col-md-7 text-end  mb-5 wow fadeInRightBig">
                <div class="swiper mySwiper">
                    <div class="swiper-wrapper">
                        @foreach (App\Models\Client::get() as $client)
                        <div class="swiper-slide text-center border border-1 rounded-3 py-4">
                            <img src="{{ asset('storage/'.$client->image) }}" width="130" height="130" alt="@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar') {{ $client->name_ar }} @else {{ $client->name }} @endif">
                        </div>
                        @endforeach
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
@stop
