@extends('front.layout.pages')
@section('title')
    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        المقالات
    @else
        Blogs
    @endif
@stop
@section('content')

    <section class="land-sec py-5 land-sec1      wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center text-md-start">
            <div class="row  align-items-center  ">
                <div class="col-xl-5 col-lg-6 text-white text-start mb-4 wow fadeInLeft" data-wow-duration="2s"
                    data-wow-delay=".5s">
                    <h5 class="  mb-3">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ App\Models\ServiceText::first()->sub_title_ar ?? '' }}
                        @else
                            {{ App\Models\ServiceText::first()->sub_title ?? '' }}
                        @endif
                    </h5>
                    <h1 class="mb-3 fw-bold" style="font-size: 50px;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ App\Models\ServiceText::first()->title_ar ?? '' }}
                        @else
                            {{ App\Models\ServiceText::first()->title ?? '' }}
                        @endif
                    </h1>
                    <p class=" prg" style="margin-bottom: 4rem;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ Str::limit(App\Models\ServiceText::first()->description_ar ?? '', 600, '...') }}
                        @else
                            {{ Str::limit(App\Models\ServiceText::first()->description ?? '', 600, '...') }}
                        @endif
                    </p>
                    <a data-bs-toggle="modal" data-bs-target="#exampleModal1"
                        class="btn btn-top  rounded-3 shadow shadow-sm fs-4" style="padding: 11px 4rem;">{{ __('Get a Quote') }} </a>

                </div>

            </div>
        </div>
    </section>



    <section class="my-5 wow fadeInUp" data-wow-duration="2s" data-wow-delay=".5s">
        <div class="swiper mySwiper ">
            <div class="swiper-wrapper">

                <div class="swiper-slide  mx-auto w-100">
                    <div class="container">
                        <div class="row prod">
                            @foreach($blogs as $key => $blog)
                            <div style="margin-bottom: 5rem;" class="col-lg-4 col-md-6  px-4 wow fadeInUp  "
                                data-wow-duration="2s" data-wow-delay=".5s">
                                <a href="#"> <img src="{{ asset('storage/'.$blog->main_image) }}"
                                        class="img-fluid w-100" alt=""></a>
                                <h4 class="prg2 mt-5" style="color: #2C113E;">
                                    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                        {{ $blog->title_ar ?? '' }}
                                    @else
                                        {{ $blog->title ?? '' }}
                                    @endif
                                </h4>
                                <p class="p prg6 mt-4 mb-5" style="line-height: 25px; color: #716F72;">
                                    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                        {{ $blog->sub_title_ar ?? '' }}
                                    @else
                                        {{ $blog->sub_title ?? '' }}
                                    @endif
                                </p>

                                <a href="{{ route('view.blog-detials',$blog->id) }}" class="card-link ">{{ __('See the Full Story') }} <i
                                        class=" ms-3 bi bi-arrow-right rmo-ico"></i> </a>

                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="swiper-pagination position-relative my-5 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">{{ $blogs->links('vendor.pagination.bootstrap-4') }}</div>
    </section>

    <section class=" endse mb-0 wow fadeInUp  " style="background-color: #FAFAFA; margin-top: 12rem; padding: 6rem 0 ;"
        data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center ">
            <div class="row text-center">
                <div class="col-lg-7 mx-auto">
                    <h1>{{ __('Want to start with 3DIT?') }}
                    </h1>
                    <p class="prg1 mt-4" style="color: #716F72;">
                        {{ __('The choice of the right 3D printing technology for depends on the projected size and number of the models. Reach out to learn more about how to open new possibilities to scale your business.') }}
                    </p>

                    <a data-bs-toggle="modal" data-bs-target="#exampleModal1"
                        class="btn btn-top  rounded-3 shadow shadow-sm fs-4 mt-5" style="padding: 11px 4rem;">
                        {{ __('Get a Quote') }}
                    </a>
                </div>
            </div>

        </div>
    </section>

@stop

{{-- @section('js')
    <script>
        var swiper = new Swiper(".mySwiper", {
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
                renderBullet: function (index, className) {
                return '<span class="' + className + '">' + (index + 1) + "</span>";
                },
            },
        });
    </script>

@stop --}}
