@extends('front.layout.pages')
@section('title')
    @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $about->title_ar }}
    @else
        {{ $about->title }}
    @endif
@stop
@section('content')

    <section class="land-sec py-5 land-sec1 position-relative    wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s"
        style="overflow-y: hidden;">
        <div class="container text-center text-md-start">
            <div class="row  align-items-center justify-content-around ">
                <div class="col-xl-5 col-lg-6 text-white  mb-4 wow fadeInLeft" data-wow-duration="2s" data-wow-delay=".5s">
                    <h5 class="  mb-3">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->slider_sub_title_ar }}
                        @else
                            {{ $about->slider_sub_title }}
                        @endif
                    </h5>
                    <h1 class="mb-3 fw-bold" style="font-size: 50px;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->slider_title_ar }}
                        @else
                            {{ $about->slider_title }}
                        @endif
                    </h1>
                    <p class=" prg2" style="margin-bottom: 4rem;">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ Str::limit($about->slider_description_ar, 500) }}
                        @else
                            {{ Str::limit($about->slider_description, 500) }}
                        @endif
                    </p>
                    <a data-bs-toggle="modal" data-bs-target="#exampleModal1"
                        class="btn btn-top  rounded-3 shadow shadow-sm fs-4" style="padding: 11px 4rem;">
                        {{ __('Get a Quote') }}
                    </a>

                </div>
                <div class=" col-xl-7  col-lg-6  mb-4 wow text-end" data-wow-duration="2s" data-wow-delay=".5s">
                    <img src="{{ asset('storage/'.$about->slider_image) }}" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>

    <section class="my-5">
        <div class="container">
            <div class="row  align-items-center">
                <div class="col-lg-6  mb-3 wow fadeInLeft" data-wow-duration="2s" data-wow-delay=".5s">
                    <h2 class="mb-5">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->title_ar }}
                        @else
                            {{ $about->title }}
                        @endif
                    </h2>
                    <p class="p prg4">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->description_ar }}
                        @else
                            {{ $about->description }}
                        @endif
                    </p>


                </div>
                <div class="col-lg-6 mb-3 wow fadeInRight" data-wow-duration="2s" data-wow-delay=".5s">
                    <img src="{{ asset('storage/'.$about->image) }}" class="img-fluid opc" alt="">
                </div>
            </div>
        </div>
    </section>
    <section class="mb-5" style="margin-top:  6rem;">
        <div class="container">
            <div class="row  align-items-center">
                <div class="col-lg-6  mb-3 wow fadeInLeft" data-wow-duration="2s" data-wow-delay=".5s">
                    <h2 class="mb-5">{{ __('Our VISION') }}

                    </h2>
                    <p class="p prg3">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->vision_ar ?? '' }}
                        @else
                            {{ $about->vision ?? '' }}
                        @endif
                    </p>


                </div>
                <div class="col-lg-6 mb-3 wow fadeInRight" data-wow-duration="2s" data-wow-delay=".5s">
                    <h2 class="mb-5">{{ __('Our MISSION') }}

                    </h2>
                    <p class="p prg3">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $about->mission_ar ?? '' }}
                        @else
                            {{ $about->mission ?? '' }}
                        @endif
                    </p>

                </div>
            </div>
        </div>
    </section>


    <section style="margin-top: 10rem; " class="sectitle mb-5 wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center">
            <div class="row text-center">
                <div class="col-lg-6 mx-auto">
                    <h2>
                        {{ __('Meet Our Professional Team') }}
                    </h2>

                </div>
            </div>

        </div>
    </section>
    <section class="team mb-5  ">

        <div class="container">

            <div class="row text-center">
                @foreach(App\Models\Team::latest()->take(8)->get() as $team)
                <div class="col-lg-3 col-sm-6 mb-4 wow fadeInUp " data-wow-duration="2s" data-wow-delay=".5s">
                    <img src="{{ asset('storage/'.$team->image) }}" class="mb-4 img-fluid" alt="">
                    <h4 class="mb-3 prg5">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $team->name_ar }}
                        @else
                            {{ $team->name }}
                        @endif
                    </h4>
                    <h5 class="prg5">
                        @if (Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                            {{ $team->position_ar }}
                        @else
                            {{ $team->position }}
                        @endif
                    </h5>

                </div>
                @endforeach
            </div>
        </div>

    </section>

    <section class="endse mb-0 wow fadeInUp  " style="background-color: #FAFAFA; margin-top: 12rem; padding: 6rem 0 ;"
        data-wow-duration="2s" data-wow-delay=".5s">
        <div class="container text-center ">
            <div class="row text-center">
                <div class="col-lg-7 mx-auto">
                    <h1>{{ __('Want to start with 3DIT?') }} </h1>
                    <p class="prg1 mt-4" style="color: #716F72;">
                        {{ __('The choice of the right 3D printing technology for depends on the projected size and number of the models. Reach out to learn more about how to open new possibilities to scale your business.') }}
                    </p>

                    <a data-bs-toggle="modal" data-bs-target="#exampleModal1"
                        class="btn btn-top rounded-3 shadow shadow-sm fs-4 mt-5"
                        style="
                            padding: 11px 4rem;
                            color: white !important;
                            border: 1px solid var(--color2)!important;
                            background-color: var(--color2)!important;
                        ">
                        {{ __('Get a Quote') }}
                    </a>
                </div>
            </div>

        </div>
    </section>

@stop
