@extends('layout.app')
@section('title')
    {{ __('Create Services') }}
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('Create Services') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('services.store') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                {{-- service name --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="name" class="form-label">{{ __('Arabic Service Name') }}</label>
                                        <input type="text"  class="form-control" id="name_ar" name="name_ar" value="{{ old('name_ar') }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end service name --}}

                                {{-- service name --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="name" class="form-label">{{ __('English Service Name') }}</label>
                                        <input type="text"  class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                                    </div>
                                </div>
                                {{-- end service name --}}

                                {{-- service image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="image" class="form-label">{{ __('Service Image') }}</label>
                                        <input type="file" id="image" name="image" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end service image --}}

                                {{-- service description --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="description" class="form-label">{{ __('Arabic Service Description') }}</label>
                                        <textarea name="description_ar" id="description_ar" class="form-control" rows="4">{{ old('description_ar') }}</textarea>

                                    </div>
                                </div>
                                {{-- end service description --}}

                                {{-- service description --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="description" class="form-label">{{ __('English Service Description') }}</label>
                                        <textarea name="description" id="description" class="form-control" rows="4">{{ old('description') }}</textarea>

                                    </div>
                                </div>
                                {{-- end service description --}}

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                    <label for="formGroupExampleInput">نوع الخدمة</label>
                                    <select name="type" id="type" class="form-control service_id">
                                        <option @if("0" == old('type')) selected @endif value="0">{{ __('خدمة') }}</option>
                                        <option @if("1" == old('type')) selected @endif value="1">{{ __('عرض') }}</option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>
@endsection
