@extends('layout.app')
@section('title')
    {{ __('النصوص الثابتة في الصفحات') }}
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0"> {{ __('النصوص الثابتة في الصفحات') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('service-text-update') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 mb-2">
                                    <h3>{{ __('صفحة المقالات') }}</h3>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar',($service_text->title_ar ?? 'الخدمات التي نقدمها')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="title" name="title" value="{{ old('title',($service_text->title ?? 'Our Services')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان الفرعي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar',($service_text->sub_title_ar ?? 'توفير الرعاية للأشخاص الأكثر مرضا في المجتمع')) }}">
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان الفرعي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="sub_title" name="sub_title" value="{{ old('sub_title',($service_text->sub_title ?? 'Providing care for the sickest people in the community')) }}">
                                    </div>
                                </div>
                                {{-- end project title --}}



                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('الفقرة بالعربي') }}</label>
                                        <textarea name="description_ar" class="form-control"  rows="3">{{ old('description_ar',($service_text->description_ar ?? 'سنعمل معك لتطوير خطط رعاية فردية ،إذا لم نتمكن من المساعدة ، يمكن تقديم الإحالات أو المشورة حول نوع الممارسات التي يمكن ان تحتاجه.نتعامل مع جميع الاستفسارات بحساسية وفي سرية تامة.')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('الفقرة بالانجليزية') }}</label>
                                        <textarea name="description" class="form-control"  rows="3">{{ old('description',($service_text->description ?? 'We will work with you to develop individualized care plans and, if we are unable to help, can provide referrals or advice about the type of practices you may need. We treat all inquiries sensitively and in the strictest confidence.')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}

                                <div class="col-lg-12 col-md-12 mt-4 col-sm-12 mb-2">
                                    <h3>{{ __('صفحة حالات الدراسة') }}</h3>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="title1_ar" name="title1_ar" value="{{ old('title1_ar',($service_text->title1_ar ?? 'الرعاية الصحية الحقيقية لعائلتك')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان بالانجليزية') }}</label>
                                        <input type="text"  class="form-control" id="title1" name="title1" value="{{ old('title1',($service_text->title1 ?? 'Real health care for your family')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('الفقرة بالعربي') }}</label>
                                        <textarea name="description1_ar" class="form-control"  rows="3">{{ old('description1_ar',($service_text->description1_ar ?? 'هذا النص هو مثال لنص يمكن أن يستبدل في نفس المساحة، لقد تم توليد هذا النص من مولد النص العربى، حيث يمكنك أن تولد مثل هذا النص أو العديد من النصوص الأخرى إضافة إلى زيادة عدد الحروف التى يولدها التطبيق.')) }}</textarea>
                                    </div>
                                </div>
                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('الفقرة بالانجليزية') }}</label>
                                        <textarea name="description1" class="form-control"  rows="3">{{ old('description1',($service_text->description1 ?? 'This text is an example of a text that can be replaced in the same space. This text was generated from the Arabic text generator, where you can generate such text or many other texts in addition to increasing the number of characters generated by the application.')) }}</textarea>
                                    </div>
                                </div>
                                {{-- <div class="col-lg-12 col-md-12 col-sm-12 mt-4 mb-2">
                                    <h3>{{ __('سكشن الاسئلة FAQs') }}</h3>
                                </div> --}}
                                {{-- end project title --}}
                                {{-- <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('عنوان الاسئلة بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="title2_ar" name="title2_ar" value="{{ old('title2_ar',($service_text->title2_ar ?? 'نحن نطور برامج محددة لعملك')) }}" required autofocus >
                                    </div>
                                </div> --}}
                                {{-- end project title --}}
                                {{-- end project title --}}
                                {{-- <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('عنوان الاسئلة بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="title2" name="title2" value="{{ old('title2',($service_text->title2 ?? 'We develop specific programs for your business')) }}" required autofocus >
                                    </div>
                                </div> --}}
                                {{-- end project title --}}

                                {{-- project title --}}
                                {{-- <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('فقرة الاسئلة بالعربي') }}</label>
                                        <textarea name="description2_ar" class="form-control"  rows="3">{{ old('description2_ar',($service_text->description2_ar ?? 'هذا النص هو مثال لنص يمكن أن يستبدل في نفس المساحة، لقد تم توليد هذا النص من مولد النص العربى، حيث يمكنك أن تولد مثل هذا يولدها التطبيق هذا النص هو مثال لنص يمكن أن يستبدل في نفس لقد تم توليد هذا النص من مولد النص العربى،')) }}</textarea>
                                    </div>
                                </div> --}}
                                {{-- end project title --}}
                                {{-- project title --}}
                                {{-- <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('فقرة الاسئلة بالانجليزي') }}</label>
                                        <textarea name="description2" class="form-control"  rows="3">{{ old('description2',($service_text->description2 ?? 'This text is an example of a text that can be replaced in the same space. This text was generated from the Arabic text generator, where you can generate such text or many other texts in addition to increasing the number of characters generated by the application.')) }}</textarea>
                                    </div>
                                </div> --}}
                                {{-- end project title --}}

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-4 mb-2">
                                    <h3>{{ __('صفحة تواصل معنا') }}</h3>
                                </div>
                                {{-- end project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('فقرة الاتصال بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="contact_ar" name="contact_ar" value="{{ old('contact_ar',($service_text->contact_ar ?? '')) }}" required>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- end project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('فقرة الاتصال بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="contact" name="contact" value="{{ old('contact',($service_text->contact ?? '')) }}" required>
                                    </div>
                                </div>
                                {{-- end project title --}}


                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>
@endsection

