@extends('layout.app')
@section('title')
    {{ __('Create Products') }}
@stop
@section('content')


    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('Create Products') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('products.store') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                {{-- client name --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="name" class="form-label">{{ __('Arabic Name') }}</label>
                                        <input type="text"  class="form-control" id="name_ar" name="name_ar" value="{{ old('name_ar') }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end client name --}}

                                {{-- client name --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="name" class="form-label">{{ __('English Name') }}</label>
                                        <input type="text"  class="form-control" id="name_en" name="name_en" value="{{ old('name_en') }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end client name --}}

                                {{-- client name --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="code" class="form-label">{{ __('Product ID') }}</label>
                                        <input type="text"  class="form-control" id="code" name="code" value="{{ old('code') }}">
                                    </div>
                                </div>
                                {{-- end client name --}}

                                {{-- client name --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="price" class="form-label">{{ __('Product Price') }}</label>
                                        <input type="text"  class="form-control" id="price" name="price" value="{{ old('price') }}" required>
                                    </div>
                                </div>
                                {{-- end client name --}}

                                {{-- Select Service --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <div class="form-group">
                                            <label for="category_id" class="form-label">{{ __('Perant Category Name') }}</label>
                                            <select name="category_id" id="category_id" class="form-control">
                                                @foreach (App\Models\Category::all() as $category)
                                                    <option @if($category->id == old('category_id')) selected  @endif value="{{ $category->id }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'){{ $category->name_ar }}@else{{ $category->name_en }}@endif</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                {{-- end Select Service --}}
                                {{-- Select Service --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <div class="form-group">
                                            <label for="category_id" class="form-label">{{ __('Sub Category Name') }}</label>
                                            <select name="sub_category_id" id="sub_category_id" class="form-control">
                                                <option value="">يجب اختيار التصنيف الرئيسي</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                {{-- end Select Service --}}

                                 {{-- project title --}}
                                 <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="short_description_ar" class="form-label">{{ __('Arabic Short Description') }}</label>
                                        <textarea name="short_description_ar" class="form-control" cols="30" rows="5">{{ old('short_description_ar') }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="short_description_en" class="form-label">{{ __('English Short Description') }}</label>
                                        <textarea name="short_description_en" class="form-control" cols="30" rows="5">{{ old('short_description_en') }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="big_description_ar" class="form-label">{{ __('Arabic Big Description') }}</label>
                                        <textarea name="big_description_ar" id="big_description_ar" class="form-control" cols="30" rows="10">{{ old('big_description_ar') }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <script>
                                    CKEDITOR.replace('big_description_ar');
                                </script>

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="big_description_en" class="form-label">{{ __('English Big Description') }}</label>
                                        <textarea name="big_description_en" id="big_description_en" class="form-control" cols="30" rows="10">{{ old('big_description_en') }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <script>
                                    CKEDITOR.replace('big_description_en');
                                </script>



                                {{-- client image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="main_image" class="form-label">{{ __('Main Image') }}</label>
                                        <input type="file" id="main_image" name="main_image" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end client image --}}

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="link" class="form-label">{{ __('رابط الفيديو') }}</label>
                                        <input type="url" name="link" class="form-control"  id="link" value="{{ old('link') }}">
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- client image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="file" class="form-label">{{ __('File') }}</label>
                                        <input type="file" id="file" name="file" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end client image --}}

                                {{-- Gallary image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="gallery" class="form-label">{{ __('Other Gallery Image') }}</label>
                                        <input type="file" multiple id="gallery" name="gallery[]" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end gallary image --}}


                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>


@endsection

@section('js')
<script type="text/javascript">
    // Department Change
    $(document).ready(function() {
    // Run code
        // Department id
        var id = $('#category_id').val();

        // AJAX request
        $.ajax({
            url: '/control-panel/sub_category/ajax/' + id,
            type: 'get',
            data: "json",
            success: function (data) {
                $('select[name="sub_category_id"]').empty();
                $('select[name="sub_category_id"]').append('<option value="">يجب اختيار التصنيف الرئيسي</option>');
                $.each(data, function (key, value) {
                    // console.log(value.name)
                    $('select[name="sub_category_id"]').append('<option value="' + value.id + '">' + value.name + '</option>')
                });

            }
        });
    });
    $('#category_id').change(function () {

        // Department id
        var id = $(this).val();

        // AJAX request
        $.ajax({
            url: '/control-panel/sub_category/ajax/' + id,
            type: 'get',
            data: "json",
            success: function (data) {
                $('select[name="sub_category_id"]').empty();
                $('select[name="sub_category_id"]').append('<option value="">يجب اختيار التصنيف الرئيسي</option>');
                $.each(data, function (key, value) {
                    // console.log(value.name)
                    $('select[name="sub_category_id"]').append('<option value="' + value.id + '">' + value.name + '</option>')
                });

            }
        });
    });
</script>
@endsection
