@extends('layout.app')
@section('title')
    {{ __('نص صفحة المنتجات') }}
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0"> {{ __('نص صفحة المنتجات') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('product-text-update') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 mb-2">
                                    <h3>{{ __('سيكشن السلايدر') }}</h3>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('Slider Title') }}</label>
                                        <input type="text"  class="form-control" id="title" name="title" value="{{ old('title',$category_text->title ?? '') }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('Slider Sub Title') }}</label>
                                        <input type="text"  class="form-control" id="sub_title" name="sub_title" value="{{ old('sub_title',$category_text->sub_title ?? '') }}">
                                    </div>
                                </div>
                                {{-- end project title --}}


                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    @if($category_text->image ?? false)
                                        <img src="{{ asset('storage/'.$category_text->image) }}" width="100" alt="...">
                                    @endif
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('Slider Image') }}</label>
                                        <input type="file" name="image"  class="form-control" id="image">
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>
@endsection

