@extends('layout.app')

@section('title')
    {{ __('الاحصائيات') }}
@stop
@section('content')
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('تعديل الاحصائية') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('prises.update',$prise->id) }}"
                            enctype="multipart/form-data">
                          @csrf
                          @method('put')

                          <div class="row">
                              {{-- client name --}}
                              <div class="col-lg-6 col-md-12 col-sm-12">
                                  <div class="form-group">
                                      <label for="name" class="form-label">{{ __('الاسم') }}</label>
                                      <input type="text" class="form-control" id="name" name="name"
                                             value="{{ old('name',$prise->name) }}" required autofocus>
                                  </div>
                              </div>
                              {{-- end client name --}}
                               {{-- client name --}}
                               <div class="col-lg-6 col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label for="number" class="form-label">{{ __('رقم الاحصائية') }}</label>
                                    <input type="text" class="form-control" id="number" name="number"
                                           value="{{ old('number',$prise->number) }}" required autofocus>
                                </div>
                            </div>
                            {{-- end client name --}}

                              {{-- client image --}}
                              <div class="col-lg-12 col-md-12 col-sm-12">
                                  <div class="form-group fallback w-100">
                                    @if($prise->icon)
                                        <img src="{{ asset('storage/'.$prise->icon) }}" width="50"
                                            alt="{{ $prise->name }}">
                                    @endif
                                      <label for="icon" class="form-label">{{ __('الايقونة') }}</label>
                                      <input type="file" id="icon" name="icon" class="form-control"
                                             data-default-file="">
                                  </div>
                              </div>
                              {{-- end client image --}}


                              <div class="col-lg-12 col-md-12 col-sm-12">
                                  <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                  <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                              </div>
                          </div>
                      </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>


@endsection
