@extends('layout.app')
@section('title')
    @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
        {{ $page->title_ar }}
    @else
        {{ $page->title }}
    @endif

@stop
@section('css')
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors-rtl.min.css') }}">
    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/css-rtl/core/menu/menu-types/vertical-menu.css') }}">
    <!-- END: Page CSS-->
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">
                            @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                {{ $page->title_ar }}
                            @else
                                {{ $page->title }}
                            @endif
                        </h2>

                        <a href="javascript:void(0);" class="btn btn-success float-right" data-toggle= "modal" data-target="#modals-create-feature">{{ __('اضافة جديد') }}</a>

                        <a href="{{ route('pages.index') }}" class="btn mx-1 btn-primary float-right">{{ __('الرجوع للخلف') }}</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">

                <!-- list section start -->
                <div class="card">
                    <div class="card-datatable table-responsive pt-0">
                        <x-alert/>
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th style="text-align: center;">{{ __('Main Image') }}</th>
                                    <th>{{ __('Title') }}</th>
                                    <th>{{ __('Description') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($page->features as $item)
                                <tr>
                                    <td><img src="{{ asset('storage/'.$item->image) }}" width="50" alt=""></td>
                                    <td>
                                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ $item->title_ar }}
                                        @else
                                            {{ $item->title }}
                                        @endif
                                    </td>
                                    <td>
                                        @if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar')
                                            {{ $item->description_ar }}
                                        @else
                                            {{ $item->description }}
                                        @endif
                                    </td>
                                    <td>
                                        <a href="javascript:void(0);" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-{{ $item->id }}">{{ __('حذف') }}</a>
                                        <a href="javascript:void(0);" class="btn btn-primary btn-sm" data-toggle= "modal" data-target= "#modals-edit-{{ $item->id }}">{{ __('تعديل') }}</a>
                                    </td>
                                </tr>

                                @empty
                                <tr>
                                    <td colspan="4" style="text-align: center">{{ __('لا يوجد مزايا لهذه الصفحة') }}</td>
                                </tr>

                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="modal fade" id="modals-create-feature">
                        <div class="modal-dialog">
                            <form class="create-new-nature modal-content pt-0"
                                  action="{{ route('features.store', $page->id) }}"
                                  method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-header mb-1">
                                    <h5 class="modal-title" id="exampleModalLabel">{{ __('انشاء ميزة جديدة') }}</h5>
                                </div>
                                <div class="modal-body flex-grow-1">

                                    <div class="form-group">
                                        <label for="username">{{ __('Image') }}</label>
                                        <input type="file" class="form-control" id="image" name="image" value="{{ old('image') }}">

                                    </div>
                                    <div class="form-group">
                                        <label for="username">{{ __('العنوان بالعربي') }}</label>
                                        <input type="text" class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar') }}"
                                               required autofocus>

                                    </div>
                                    <div class="form-group">
                                        <label for="username">{{ __('Title in english') }}</label>
                                        <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}"
                                               required>

                                    </div>
                                    <div class="form-group">
                                        <label for="username">{{ __('الوصف بالعربي') }}</label>
                                        <textarea name="description_ar" id="description_ar" class="form-control" rows="3">{{ old('description_ar') }}</textarea>
                                    </div>

                                    <div class="form-group">
                                        <label for="username">{{ __('Description in english') }}</label>
                                        <textarea name="description" id="description" class="form-control" rows="3">{{ old('description') }}</textarea>
                                    </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('حفظ') }}</button>
                                    <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    @foreach ($page->features as $item)
                         <!-- Modal to add new user starts-->
                         <div class="modal fade" id="modals-delete-{{ $item->id }}">
                            <div class="modal-dialog">
                                <form class="add-new-user modal-content pt-0" action="{{ route('features.destroy',$item->id) }}"
                                    method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel">{{ __('حذف') }}</h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <h4>{{ __('هل تريد حذف ؟') }}</h4>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-danger mr-1 data-submit">{{ __('حذف') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new user Ends-->

                        <div class="modal fade" id="modals-edit-{{ $item->id }}">
                            <div class="modal-dialog">
                                <form class="create-new-nature modal-content pt-0"
                                      action="{{ route('features.update', $item->id) }}"
                                      method="POST" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel">{{ __('تعديل الميزة') }}</h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        @if($item->image)
                                            <img src="{{ asset('storage/'.$item->image) }}" width="100" alt="...">
                                        @endif
                                        <div class="form-group fallback w-100">
                                            <label for="image" class="form-label">{{ __('Image') }}</label>
                                            <input type="file" id="image" name="image" class="form-control" data-default-file="" >
                                        </div>
                                        <div class="form-group">
                                            <label for="username">{{ __('العنوان بالعربي') }}</label>
                                            <input type="text" class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar',$item->title_ar) }}"
                                                   required autofocus>

                                        </div>
                                        <div class="form-group">
                                            <label for="username">{{ __('Title in english') }}</label>
                                            <input type="text" class="form-control" id="title" name="title" value="{{ old('title',$item->title) }}"
                                                   required>

                                        </div>

                                        <div class="form-group">
                                            <label for="username">{{ __('الوصف بالعربي') }}</label>
                                            <textarea name="description_ar" id="description_ar" class="form-control" rows="3">{{ old('description_ar',$item->description_ar) }}</textarea>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">{{ __('Description in english') }}</label>
                                            <textarea name="description" id="description" class="form-control" rows="3">{{ old('description',$item->description) }}</textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('تعديل') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>

                    @endforeach
                </div>
                <!-- list section end -->
            </section>
            <!-- users list ends -->
        </div>
    </div>
@endsection

