@extends('layout.app')
@section('title')
    {{ __('Edit Page') }}
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('Edit Page') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('pages.update',$page->id) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="row">

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <div class="form-group">
                                            <label for="menu_id" class="form-label">{{ __('Menu Name') }}</label>

                                            <select name="menu_id" id="menu_id" class="form-control">
                                                @foreach ($menus as $menu)
                                                    <option @if($menu->id == old('menu_id',$page->menu_id)) selected  @endif value="{{ $menu->id }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'){{ $menu->name_ar }} @else {{ $menu->name  }} @endif</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <h4>{{ __('Page Header') }}</h4>
                                </div>
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="title_ar" class="form-label">{{ __('عنوان الترويسة بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar',$page->title_ar) }}" required>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('عنوان الترويسة بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="title" name="title" value="{{ old('title',$page->title) }}" required>
                                    </div>
                                </div>
                                {{-- end project title --}}


                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('عنوان الترويسة الفرعي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar',$page->sub_title_ar) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title" class="form-label">{{ __('عنوان الترويسة الفرعي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="sub_title" name="sub_title" value="{{ old('sub_title',$page->sub_title) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- main image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    @if($page->header_image)
                                        <img src="{{ asset('storage/'.$page->header_image) }}" width="100" alt="{{ $page->title }}">
                                    @endif
                                    <div class="form-group fallback w-100">
                                        <label for="header_image" class="form-label">{{ __('صورة الترويسة') }}</label>
                                        <input type="file" id="header_image" name="header_image" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end main image --}}

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <h4>{{ __('Page Body') }}</h4>
                                </div>
                                {{-- main image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    @if($page->main_image)
                                        <img src="{{ asset('storage/'.$page->main_image) }}" width="100" alt="{{ $page->title }}">
                                    @endif
                                    <div class="form-group fallback w-100">
                                        <label for="main_image" class="form-label">{{ __('Page Main Image') }}</label>
                                        <input type="file" id="main_image" name="main_image" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end main image --}}



                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="description_ar" class="form-label">{{ __('الوصف بالعربي') }}</label>
                                        <textarea name="description_ar" id="description_ar" cols="30" rows="10">{{ old('description_ar',$page->description_ar) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <script>
                                    CKEDITOR.replace('description_ar');
                                </script>

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="description" class="form-label">{{ __('الوصف بالانجليزي') }}</label>
                                        <textarea name="description" id="description" cols="30" rows="10">{{ old('description',$page->description) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <script>
                                    CKEDITOR.replace('description');
                                </script>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <h4>{{ __('Feature Section') }}</h4>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="feature_title_ar" class="form-label">{{ __('العنوان بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="feature_title_ar" name="feature_title_ar" value="{{ old('feature_title_ar',$page->feature_title_ar) }}"  >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="feature_title" class="form-label">{{ __('العنوان بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="feature_title" name="feature_title" value="{{ old('feature_title',$page->feature_title) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}


                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="feature_sub_title_ar" class="form-label">{{ __('العنوان الفرعي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="feature_sub_title_ar" name="feature_sub_title_ar" value="{{ old('feature_sub_title_ar',$page->feature_sub_title_ar) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="feature_sub_title" class="form-label">{{ __('العنوان الفرعي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="feature_sub_title" name="feature_sub_title" value="{{ old('feature_sub_title',$page->feature_sub_title) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <h4>{{ __('Theme Section') }}</h4>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="theme_title_ar" class="form-label">{{ __('العنوان بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="theme_title_ar" name="theme_title_ar" value="{{ old('theme_title_ar',$page->theme_title_ar) }}"  >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="theme_title" class="form-label">{{ __('العنوان بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="theme_title" name="theme_title" value="{{ old('theme_title',$page->theme_title) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}


                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="theme_sub_title_ar" class="form-label">{{ __('العنوان الفرعي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="theme_sub_title_ar" name="theme_sub_title_ar" value="{{ old('theme_sub_title_ar',$page->theme_sub_title_ar) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="theme_sub_title" class="form-label">{{ __('العنوان الفرعي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="theme_sub_title" name="theme_sub_title" value="{{ old('theme_sub_title',$page->theme_sub_title) }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <h4>{{ __('Footer Section') }}</h4>
                                </div>

                                {{-- Gallary image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    @foreach ($page->images as $gallery)
                                        <div class="form-check form-check-inline">
                                            {{ __('Delete') }} <input type="checkbox" name="{{ "check_".$gallery->id }}" class="form-check-input" value="">
                                        </div>
                                        <img src="{{ asset('storage/'.$gallery->image) }}" width="100" alt="{{ $page->title }}">
                                    @endforeach
                                    <div class="form-group fallback w-100">
                                        <label for="gallery" class="form-label">{{ __('Other Gallery Image') }}</label>
                                        <input type="file" multiple id="gallery" name="gallery[]" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end gallary image --}}

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="tags" class="form-label">{{ __('Page Tags') }}</label>
                                        <input type="text" value="{{ old('tags',($tags ?? ' ')) }}" class="form-control" data-role="tagsinput"  name="tags">
                                    </div>
                                </div>
                                {{-- end project title --}}


                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>
@endsection

