@extends('layout.app')
@section('title')
    {{ __('Create Opinion') }}
@stop
@section('content')


    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('Create Opinion') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                         <!-- users edit account form start -->
                         <form method="POST" action="{{ route('client-opinion.store') }}"
                            enctype="multipart/form-data">
                          @csrf

                          <div class="row">
                              {{-- client name --}}
                              <div class="col-lg-6 col-md-6 col-sm-12">
                                  <div class="form-group">
                                      <label for="name_ar" class="form-label">{{ __('الاسم بالعربي') }}</label>
                                      <input type="text" class="form-control" id="name_ar" name="name_ar"
                                             value="{{ old('name_ar') }}" required autofocus>
                                  </div>
                              </div>
                              {{-- end client name --}}
                              {{-- client name --}}
                              <div class="col-lg-6 col-md-6 col-sm-12">
                                  <div class="form-group">
                                      <label for="name" class="form-label">{{ __('الاسم بالانجليزي') }}</label>
                                      <input type="text" class="form-control" id="name" name="name"
                                             value="{{ old('name') }}" required autofocus>
                                  </div>
                              </div>
                              {{-- end client name --}}

                              {{-- client image --}}
                              <div class="col-lg-12 col-md-12 col-sm-12">
                                  <div class="form-group fallback w-100">
                                      <label for="image" class="form-label">{{ __('الصورة') }}</label>
                                      <input type="file" id="image" name="image" class="form-control"
                                             data-default-file="">
                                  </div>
                              </div>
                              {{-- end client image --}}

                              {{-- project title --}}
                              <div class="col-lg-12 col-md-12 col-sm-12">
                                  <div class="form-group">
                                      <label for="message_ar" class="form-label">{{ __('الرأي بالعربي') }}</label>
                                      <textarea name="message_ar" class="form-control"  rows="3">{{ old('message_ar') }}</textarea>
                                  </div>
                              </div>
                              {{-- end project title --}}
                              {{-- project title --}}
                              <div class="col-lg-12 col-md-12 col-sm-12">
                                  <div class="form-group">
                                      <label for="message" class="form-label">{{ __('الرأي بالانجليزي') }}</label>
                                      <textarea name="message" class="form-control"  rows="3">{{ old('message') }}</textarea>
                                  </div>
                              </div>
                              {{-- end project title --}}

                              <div class="col-lg-6 col-md-6 col-sm-12">
                                  <div class="form-group">
                                      <label for="client_position_ar" class="form-label">{{ __('موقع العمل بالعربي') }}</label>
                                      <input type="text" class="form-control" id="client_position_ar" name="client_position_ar"
                                             value="{{ old('client_position_ar') }}" >
                                  </div>
                              </div>
                              <div class="col-lg-6 col-md-6 col-sm-12">
                                  <div class="form-group">
                                      <label for="client_position" class="form-label">{{ __('موقع العمل بالانجليزي') }}</label>
                                      <input type="text" class="form-control" id="client_position" name="client_position"
                                             value="{{ old('client_position') }}" >
                                  </div>
                              </div>



                              <div class="col-lg-12 col-md-12 col-sm-12">
                                  <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                  <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                              </div>
                          </div>
                      </form>
                      <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>


@endsection

