@extends('layout.app')
@section('title')
    {{ __('الاصناف') }}
@stop
@section('css')
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors-rtl.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css') }}">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/css-rtl/core/menu/menu-types/vertical-menu.css') }}">
    <!-- END: Page CSS-->
@stop


@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('الاصناف') }}</h2>

                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <!-- list section start -->
                <div class="card">
                    <div class="card-datatable table-responsive pt-0">
                        <x-alert/>
                        <table class="category-list-table table">
                            <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>{{ __('الاسم بالعربي') }}</th>
                                <th>{{ __('الاسم بالانجليزي') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
                <!-- list section end -->
            </section>
            <!-- users list ends -->
        </div>

        <div class="modal fade" id="modals-create">
            <div class="modal-dialog">
                <form class="create-new-nature modal-content pt-0"
                      action="{{ route('categories.store') }}"
                      method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header mb-1">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('انشاء مصنف جديد') }}</h5>
                    </div>
                    <div class="modal-body flex-grow-1">
                        <div class="form-group">
                            <label for="username">{{ __('اسم المصنف بالعربي') }}</label>
                            <input type="text" class="form-control" id="name_ar" name="name_ar" value="{{ old('name_ar') }}"
                                   required autofocus>

                        </div>

                        <div class="form-group">
                            <label for="username">{{ __('اسم المصنف بالانجليزي') }}</label>
                            <input type="text" class="form-control" id="name_en" name="name_en" value="{{ old('name_en') }}"
                                   required autofocus>

                        </div>
                        <div class="form-group">
                            <label for="image" class="form-label">{{ __('Main Image') }}</label>
                            <input type="file" id="image" name="image" class="form-control" data-default-file="" >
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('حفظ') }}</button>
                        <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @foreach ($categories as $category)

            <div class="modal fade" id="modals-edit-{{ $category->id }}">
                <div class="modal-dialog">
                    <form class="create-new-nature modal-content pt-0"
                          action="{{ route('categories.update', $category->id) }}"
                          method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('تعديل الصنف') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">
                            <div class="form-group">
                                <label for="username">{{ __('اسم المصنف بالعربي') }}</label>
                                <input type="text" class="form-control" id="name_ar" name="name_ar" value="{{ old('name_ar', $category->name_ar) }}"
                                       required autofocus>
                            </div>

                            <div class="form-group">
                                <label for="username">{{ __('اسم المصنف بالانجليزي') }}</label>
                                <input type="text" class="form-control" id="name_en" name="name_en" value="{{ old('name_en', $category->name_en) }}"
                                       required autofocus>
                            </div>

                            @if($category->image)
                                <img src="{{ asset('storage/'.$category->image) }}" width="100" alt="...">
                            @endif
                            <div class="form-group">
                                <label for="image" class="form-label">{{ __('Main Image') }}</label>
                                <input type="file" id="image" name="image" class="form-control" data-default-file="" >
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('تعديل') }}</button>
                            <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        <!-- Modal to add new user starts-->
            <div class="modal fade" id="modals-delete-{{ $category->id }}">
                <div class="modal-dialog">
                    <form class="add-new-user modal-content pt-0"
                          action="{{ route('categories.destroy', $category->id) }}"
                          method="POST">
                        @csrf
                        @method('DELETE')
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('حذف الصنف') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">
                            <h4>{{ __('هل تريد حذف المصنف ؟') }}</h4>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger mr-1 data-submit">{{ __('حذف') }}</button>
                            <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Modal to add new user Ends-->
        @endforeach
    </div>
@endsection

@section('js')
    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/responsive.bootstrap4.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.rowGroup.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js') }}"></script>

    <!-- END: Page Vendor JS-->

    <script>
        const create = '{{ __('اضافة صنف') }}';
        const search = '{{ __('Search') }}';
        const createUrl = "{{ route('categories.create') }}";
        const mainUrl = "{{ route('categories.index') }}"
    </script>

    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/emad.js') }}"></script>
    <!-- END: Page JS-->

@stop
