@extends('layout.app')
@section('title')
    {{ __('Create Blogs') }}
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('Create Blogs') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('blogs.store') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('Arabic Blog Title') }}</label>
                                        <input type="text"  class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar') }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('English Blog Title') }}</label>
                                        <input type="text"  class="form-control" id="title" name="title" value="{{ old('title') }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('Arabic Blog Sub Title') }}</label>
                                        <input type="text"  class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar') }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title" class="form-label">{{ __('English Blog Sub Title') }}</label>
                                        <input type="text"  class="form-control" id="sub_title" name="sub_title" value="{{ old('sub_title') }}" >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- main image --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="type" class="form-label">{{ __('النوع') }}</label>
                                        <select name="type" class="form-control" id="type">
                                            <option @if(old('type') == '1') selected @endif value="1">خبر</option>
                                            <option @if(old('type') == '0') selected @endif value="0">مقال</option>
                                        </select>
                                    </div>
                                </div>
                                {{-- end main image --}}

                                {{-- main image --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="main_image" class="form-label">{{ __('Blog Main Image') }}</label>
                                        <input type="file" id="main_image" name="main_image" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end main image --}}


                                 {{-- project title --}}
                                 <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="shot_desc_ar" class="form-label">{{ __('Arabic Short Description') }}</label>
                                        <textarea name="shot_desc_ar" class="form-control" id="shot_desc_ar" cols="30" rows="3">{{ old('shot_desc_ar') }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="shot_desc" class="form-label">{{ __('English Short Description') }}</label>
                                        <textarea name="shot_desc" class="form-control" id="shot_desc" cols="30" rows="3">{{ old('shot_desc') }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}


                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="description_ar" class="form-label">{{ __('Arabic Blog Description') }}</label>
                                        <textarea name="description_ar" id="description_ar" cols="30" rows="10">{{ old('description_ar') }}</textarea>
                                    </div>
                                    <script>
                                        CKEDITOR.replace('description_ar');
                                    </script>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="description" class="form-label">{{ __('English Blog Description') }}</label>
                                        <textarea name="description" id="description" cols="30" rows="10">{{ old('description') }}</textarea>
                                    </div>
                                    <script>
                                        CKEDITOR.replace('description');
                                    </script>
                                </div>
                                {{-- end project title --}}

                                {{-- Gallary image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="gallery" class="form-label">{{ __('Other Gallery Image') }}</label>
                                        <input type="file" multiple id="gallery" name="gallery[]" class="form-control" data-default-file="" >
                                    </div>
                                </div>
                                {{-- end gallary image --}}

                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="tags" class="form-label">{{ __('Blog Tags') }}</label>
                                        <input type="text" value="{{ old('tags') }}" class="form-control" data-role="tagsinput"  name="tags">
                                    </div>
                                </div>
                                {{-- end project title --}}


                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>

                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>
@endsection

