@extends('layout.app')
@section('title')
    {{ __('Create Sub Benefit') }}
@stop
@section('content')


    <div class="content-wrapper">

        <div class="content-body">
            <section class="form-control-repeater">
                <div class="row">
                    <!-- Invoice repeater -->
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">{{ __('Sub Benefit') }}</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('sub-benefit.store', $benefit->id) }}" class="invoice-repeater"
                                    method="POST">
                                    @csrf
                                    <div data-repeater-list="invoice">
                                        @forelse($benefit->subBenefits as $item)
                                            <div data-repeater-item>
                                                <div class="row d-flex align-items-end">
                                                    <div class="col-md-10 col-10">
                                                        <div class="row">
                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemcost">{{ __('العنوان باللغة العربية') }}</label>
                                                                    <input type="text" class="form-control"
                                                                        name="title_ar" id="title_ar"
                                                                        aria-describedby="title_ar"
                                                                        value="{{ $item->title_ar }}"
                                                                        placeholder="title_ar" />
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemquantity">{{ __('Title in english') }}</label>
                                                                    <input type="text" class="form-control"
                                                                        name="title_en" id="title_en"
                                                                        aria-describedby="title_en"
                                                                        value="{{ $item->title_en }}"
                                                                        placeholder="title_en" />
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemcost">{{ __('الوصف باللغة العربية') }}</label>
                                                                    <textarea name="description_ar" class="form-control" id="description_ar" cols="30" rows="3">{{ $item->description_ar }}</textarea>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemquantity">{{ __('Description in english') }}</label>
                                                                    <textarea name="description_en" class="form-control" id="description_en" cols="30" rows="3">{{ $item->description_en }}</textarea>

                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>


                                                    <div class="col-md-2 col-12 mb-50">
                                                        <div class="form-group">
                                                            <button class="btn btn-outline-danger text-nowrap px-1"
                                                                data-repeater-delete type="button">
                                                                <i data-feather="x" class="mr-25"></i>
                                                                <span>{{ __('Delete') }}</span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <hr />
                                            </div>
                                        @empty

                                            <div data-repeater-item>
                                                <div class="row d-flex align-items-end">
                                                    <div class="col-md-10 col-10">
                                                        <div class="row">
                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemcost">{{ __('العنوان باللغة العربية') }}</label>
                                                                    <input type="text" class="form-control"
                                                                        name="title_ar" id="title_ar"
                                                                        aria-describedby="title_ar"
                                                                        placeholder="title_ar" />
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemquantity">{{ __('Title in english') }}</label>
                                                                    <input type="text" class="form-control"
                                                                        name="title_en" id="title_en"
                                                                        aria-describedby="title_en"
                                                                        placeholder="title_en" />
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemcost">{{ __('الوصف باللغة العربية') }}</label>
                                                                    <textarea name="description_ar" class="form-control" id="description_ar" cols="30" rows="3"></textarea>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-6 col-12">
                                                                <div class="form-group">
                                                                    <label for="itemquantity">{{ __('Description in english') }}</label>
                                                                    <textarea name="description_en" class="form-control" id="description_en" cols="30" rows="3"></textarea>

                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>


                                                    <div class="col-md-2 col-12 mb-50">
                                                        <div class="form-group">
                                                            <button class="btn btn-outline-danger text-nowrap px-1"
                                                                data-repeater-delete type="button">
                                                                <i data-feather="x" class="mr-25"></i>
                                                                <span>{{ __('Delete') }}</span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <hr />
                                            </div>
                                        @endforelse
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <button class="btn btn-icon btn-primary" type="button" data-repeater-create>
                                                <i data-feather="plus" class="mr-25"></i>
                                                <span>{{ __('Add New') }}</span>
                                            </button>
                                            <button class="btn btn-icon btn-success ml-2" type="submit" e>
                                                <span>{{ __('Save') }}</span>
                                            </button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- /Invoice repeater -->
                </div>
            </section>

        </div>
    </div>


@endsection

@section('js')

    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/forms/repeater/jquery.repeater.min.js') }}"></script>
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/scripts/forms/form-repeater.js') }}"></script>
    <!-- END: Page JS-->
@stop
