@extends('layout.app')
@section('title')
    {{ __('مميزات المنتجات') }}
@stop
@section('css')
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/vendors/css/vendors-rtl.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css') }}">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css"
          href="{{ asset('app-assets/css-rtl/core/menu/menu-types/vertical-menu.css') }}">
    <!-- END: Page CSS-->
@stop


@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('مميزات المنتجات') }}</h2>

                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <!-- list section start -->
                <div class="card">
                    <div class="card-datatable table-responsive pt-0">
                        <x-alert/>
                        <table class="benefit-list-table table">
                            <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>{{ __('Title') }}</th>
                                <th>{{ __('Sub Title') }}</th>
                                <th>{{ __('المنتج') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
                <!-- list section end -->
            </section>
            <!-- users list ends -->
        </div>

        @if(request()->query('productID'))
        <div class="modal fade" id="modals-create-benefit">
            <div class="modal-dialog">
                <form class="create-new-nature modal-content pt-0"
                      action="{{ route('benefits.store') }}"
                      method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header mb-1">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('انشاء ميزة جديدة') }}</h5>
                    </div>
                    <div class="modal-body flex-grow-1">

                        <div class="form-group">
                            <label for="username">{{ __('Image') }}</label>
                            <input type="file" class="form-control" id="image" name="image" value="{{ old('image') }}">

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('العنوان بالعربي') }}</label>
                            <input type="text" class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar') }}"
                                   required autofocus>

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('Title in english') }}</label>
                            <input type="text" class="form-control" id="title_en" name="title_en" value="{{ old('title_en') }}"
                                   required>

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('العنوان الفرعي بالعربي') }}</label>
                            <input type="text" class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar') }}"
                                   >

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('Sub Title in english') }}</label>
                            <input type="text" class="form-control" id="sub_title_en" name="sub_title_en" value="{{ old('sub_title_en') }}"
                                   >
                        </div>

                        <div class="form-group">
                            <label for="username">{{ __('الوصف بالعربي') }}</label>
                            <textarea name="description_ar" id="description_ar" class="form-control" rows="3">{{ old('description_ar') }}</textarea>
                        </div>

                        <div class="form-group">
                            <label for="username">{{ __('Description in english') }}</label>
                            <textarea name="description_en" id="description_en" class="form-control" rows="3">{{ old('description_en') }}</textarea>
                        </div>

                        <div class="form-group">
                            {{-- <label for="image" class="form-label">{{ __('Product') }}</label> --}}
                            <input type="hidden" name="product_id" value="{{ request()->query('productID') }}">
                            <input type="hidden" name="status" value="0">

                            {{-- <select name="product_id" id="product_id" class="form-control">
                                @foreach (App\Models\Product::all() as $product)
                                    <option @if($product->id == old('product_id')) selected  @endif value="{{ $product->id }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'){{ $product->name_ar }}@else{{ $product->name_en }}@endif</option>
                                @endforeach
                            </select> --}}
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('حفظ') }}</button>
                        <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="modal fade" id="modals-create-other-benefit">
            <div class="modal-dialog">
                <form class="create-new-nature modal-content pt-0"
                      action="{{ route('benefits.store') }}"
                      method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header mb-1">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('انشاء ميزة اخرى جديدة') }}</h5>
                    </div>
                    <div class="modal-body flex-grow-1">

                        <div class="form-group">
                            <label for="username">{{ __('Image') }}</label>
                            <input type="file" class="form-control" id="image" name="image" value="{{ old('image') }}">
                        </div>

                        <div class="form-group">
                            <label for="username">{{ __('العنوان بالعربي') }}</label>
                            <input type="text" class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar') }}"
                                   required autofocus>

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('Title in english') }}</label>
                            <input type="text" class="form-control" id="title_en" name="title_en" value="{{ old('title_en') }}"
                                   required>

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('العنوان الفرعي بالعربي') }}</label>
                            <input type="text" class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar') }}"
                                   >

                        </div>
                        <div class="form-group">
                            <label for="username">{{ __('Sub Title in english') }}</label>
                            <input type="text" class="form-control" id="sub_title_en" name="sub_title_en" value="{{ old('sub_title_en') }}"
                                   >
                        </div>

                        <div class="form-group">
                            <label for="username">{{ __('الوصف بالعربي') }}</label>
                            <textarea name="description_ar" id="description_ar" class="form-control" rows="3">{{ old('description_ar') }}</textarea>
                        </div>

                        <div class="form-group">
                            <label for="username">{{ __('Description in english') }}</label>
                            <textarea name="description_en" id="description_en" class="form-control" rows="3">{{ old('description_en') }}</textarea>
                        </div>

                        <div class="form-group">
                            {{-- <label for="image" class="form-label">{{ __('Product') }}</label> --}}
                            <input type="hidden" name="product_id" value="{{ request()->query('productID') }}">
                            <input type="hidden" name="status" value="1">
                            {{-- <select name="product_id" id="product_id" class="form-control">
                                @foreach (App\Models\Product::all() as $product)
                                    <option @if($product->id == old('product_id')) selected  @endif value="{{ $product->id }}">@if(Mcamara\LaravelLocalization\Facades\LaravelLocalization::getCurrentLocale() == 'ar'){{ $product->name_ar }}@else{{ $product->name_en }}@endif</option>
                                @endforeach
                            </select> --}}
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('حفظ') }}</button>
                        <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
        @endif
    @foreach ($benefits as $benefit)

            <div class="modal fade" id="modals-edit-{{ $benefit->id }}">
                <div class="modal-dialog">
                    <form class="create-new-nature modal-content pt-0"
                          action="{{ route('benefits.update', $benefit->id) }}"
                          method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('تعديل الميزة') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">
                            @if($benefit->image)
                                <img src="{{ asset('storage/'.$benefit->image) }}" width="100" alt="...">
                            @endif
                            <div class="form-group fallback w-100">
                                <label for="image" class="form-label">{{ __('Image') }}</label>
                                <input type="file" id="image" name="image" class="form-control" data-default-file="" >
                            </div>
                            <div class="form-group">
                                <label for="username">{{ __('العنوان بالعربي') }}</label>
                                <input type="text" class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar',$benefit->title_ar) }}"
                                       required autofocus>

                            </div>
                            <div class="form-group">
                                <label for="username">{{ __('Title in english') }}</label>
                                <input type="text" class="form-control" id="title_en" name="title_en" value="{{ old('title_en',$benefit->title_en) }}"
                                       required>

                            </div>
                            <div class="form-group">
                                <label for="username">{{ __('العنوان الفرعي بالعربي') }}</label>
                                <input type="text" class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar',$benefit->sub_title_ar) }}"
                                       >

                            </div>
                            <div class="form-group">
                                <label for="username">{{ __('Sub Title in english') }}</label>
                                <input type="text" class="form-control" id="sub_title_en" name="sub_title_en" value="{{ old('sub_title_en',$benefit->sub_title_en) }}"
                                       >
                            </div>

                            <div class="form-group">
                                <label for="username">{{ __('الوصف بالعربي') }}</label>
                                <textarea name="description_ar" id="description_ar" class="form-control" rows="3">{{ old('description_ar',$benefit->description_ar) }}</textarea>
                            </div>

                            <div class="form-group">
                                <label for="username">{{ __('Description in english') }}</label>
                                <textarea name="description_en" id="description_en" class="form-control" rows="3">{{ old('description_en',$benefit->description_en) }}</textarea>
                            </div>

                            <div class="form-group">
                                <input type="hidden" name="product_id" value="{{ request()->query('productID') }}">
                                <input type="hidden" name="status" value="{{ $benefit->status }}">

                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('تعديل') }}</button>
                            <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        <!-- Modal to add new user starts-->
            <div class="modal fade" id="modals-delete-{{ $benefit->id }}">
                <div class="modal-dialog">
                    <form class="add-new-user modal-content pt-0"
                          action="{{ route('benefits.destroy', $benefit->id) }}"
                          method="POST">
                        @csrf
                        @method('DELETE')
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('حذف الميزة') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">
                            <h4>{{ __('هل تريد حذف الميزة ؟') }}</h4>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger mr-1 data-submit">{{ __('حذف') }}</button>
                            <button type="reset" class="btn btn-outline-secondary" data-dismiss="modal">{{ __('الغاء') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Modal to add new user Ends-->
        @endforeach
    </div>
@endsection

@section('js')
    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/responsive.bootstrap4.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.rowGroup.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js') }}"></script>

    <!-- END: Page Vendor JS-->

    <script>
        const create = '{{ __('اضافة ميزة') }}';
        const createOther = '{{ __('اضافة ميزة اخرى') }}';
        const search = '{{ __('Search') }}';
        const productID = '{{ request()->query('productID') }}'
        const mainUrl = "{{ route('benefits.index') }}"
    </script>

    <!-- BEGIN: Page JS-->
    <script src="{{ asset('app-assets/js/emad.js') }}"></script>
    <!-- END: Page JS-->

@stop
