@extends('layout.app')
@section('title')
    {{ __('من نحن') }}
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{ __('من نحن') }}</h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <x-alert/>
                        <!-- users edit account form start -->
                        <form method="POST" action="{{ route('about-us-update') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                {{-- main image --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="slider_image" class="form-label">{{ __('صورة السلايدر') }}</label>
                                        <input type='file' onchange="loadFile_image(slider_image)" name="slider_image" id="slider_image"
                                        class="@error('slider_image') is-invalid @enderror"
                                        style="display:none;"/>
                                        <button id="output_logo" type="button"
                                                onclick="document.getElementById('slider_image').click();" value="emad"
                                                style="
                                                    width: 200px;
                                                    height: 200px;
                                                    border-radius: 10%;
                                                    background-color: #0a1128;
                                                    background-image: url({{ asset('storage/'.($about_us->slider_image ?? 'default.png')) }});
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    "/>
                                    </div>
                                </div>
                                <script>
                                    var loadFile_image = function (image1) {
                                        var image1 = document.getElementById('output_logo');
                                        var src1 = URL.createObjectURL(event.target.files[0]);
                                        image1.style.backgroundImage = 'url(' + src1 + ')';
                                    };
                                </script>


                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="slider_title_ar" class="form-label">{{ __('العنوان السلايدر الرئيسي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="slider_title_ar" name="slider_title_ar" value="{{ old('slider_title_ar',($about_us->slider_title_ar ?? '')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="slider_title" class="form-label">{{ __('العنوان السلايدر الرئيسي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="slider_title" name="slider_title" value="{{ old('slider_title',($about_us->slider_title ?? '')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="slider_sub_title_ar" class="form-label">{{ __('العنوان السلايدر الفرعي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="slider_sub_title_ar" name="slider_sub_title_ar" value="{{ old('slider_sub_title_ar',($about_us->slider_sub_title_ar ?? '')) }}">
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="slider_sub_title" class="form-label">{{ __('العنوان السلايدر الفرعي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="slider_sub_title" name="slider_sub_title" value="{{ old('slider_sub_title',($about_us->slider_sub_title ?? '')) }}">
                                    </div>
                                </div>
                                {{-- end project title --}}



                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="slider_description_ar" class="form-label">{{ __('Arabic Slider Description') }}</label>
                                        <textarea name="slider_description_ar" class="form-control"  rows="3">{{ old('slider_description_ar',($about_us->slider_description_ar ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label for="slider_description" class="form-label">{{ __('English Slider Description') }}</label>
                                        <textarea name="slider_description" class="form-control"  rows="3">{{ old('slider_description',($about_us->slider_description ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group fallback w-100">
                                        <label for="image" class="form-label">{{ __('الصورة') }}</label>
                                        <input type='file' onchange="loadFile_image1(image)" name="image" id="image"
                                        class="@error('image') is-invalid @enderror"
                                        style="display:none;"/>
                                        <button id="output_logo1" type="button"
                                                onclick="document.getElementById('image').click();" value="emad"
                                                style="
                                                    width: 200px;
                                                    height: 200px;
                                                    border-radius: 10%;
                                                    background-color: #0a1128;
                                                    background-image: url({{ asset('storage/'.($about_us->image ?? 'default.png')) }});
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    "/>
                                    </div>
                                </div>
                                <script>
                                    var loadFile_image1 = function (image1) {
                                        var image1 = document.getElementById('output_logo1');
                                        var src1 = URL.createObjectURL(event.target.files[0]);
                                        image1.style.backgroundImage = 'url(' + src1 + ')';
                                    };
                                </script>

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('العنوان الرئيسي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="title_ar" name="title_ar" value="{{ old('title_ar',($about_us->title_ar ?? '')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="title" class="form-label">{{ __('العنوان الرئيسي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="title" name="title" value="{{ old('title',($about_us->title ?? '')) }}" required autofocus >
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title_ar" class="form-label">{{ __('العنوان الفرعي بالعربي') }}</label>
                                        <input type="text"  class="form-control" id="sub_title_ar" name="sub_title_ar" value="{{ old('sub_title_ar',($about_us->sub_title_ar ?? '')) }}">
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="sub_title" class="form-label">{{ __('العنوان الفرعي بالانجليزي') }}</label>
                                        <input type="text"  class="form-control" id="sub_title" name="sub_title" value="{{ old('sub_title',($about_us->sub_title ?? '')) }}">
                                    </div>
                                </div>
                                {{-- end project title --}}


                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="description_ar" class="form-label">{{ __('Arabic Description') }}</label>
                                        <textarea name="description_ar" class="form-control"  rows="5">{{ old('description_ar',($about_us->description_ar ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="description" class="form-label">{{ __('English Description') }}</label>
                                        <textarea name="description" class="form-control"  rows="5">{{ old('description',($about_us->description ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="vision_ar" class="form-label">{{ __('Arabic Vision') }}</label>
                                        <textarea name="vision_ar" class="form-control"  rows="5">{{ old('vision_ar',($about_us->vision_ar ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="vision" class="form-label">{{ __('English Vision') }}</label>
                                        <textarea name="vision" class="form-control"  rows="5">{{ old('vision',($about_us->vision ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}

                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="mission_ar" class="form-label">{{ __('Arabic Mission') }}</label>
                                        <textarea name="mission_ar" class="form-control"  rows="5">{{ old('mission_ar',($about_us->mission_ar ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}
                                {{-- project title --}}
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="mission" class="form-label">{{ __('English Mission') }}</label>
                                        <textarea name="mission" class="form-control"  rows="5">{{ old('mission',($about_us->mission ?? '')) }}</textarea>
                                    </div>
                                </div>
                                {{-- end project title --}}


                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <button type="submit" class="btn btn-primary">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-light">{{ __('Cencel') }}</button>
                                </div>
                            </div>
                        </form>
                        <!-- users edit account form ends -->

                    </div>
                </div>
            </section>
            <!-- users edit ends -->

        </div>
    </div>
@endsection

