@extends('layout.app')

@section('title')
    {{__('FAQs')}}
@stop
@section('css')
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/vendors-rtl.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{asset('app-assets/css-rtl/core/menu/menu-types/vertical-menu.css')}}">
    <!-- END: Page CSS-->
@stop

@section('content')

    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">{{__('FAQs')}}</h2>

                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <!-- list section start -->
                <div class="card">
                    <div class="card-datatable table-responsive pt-0">
                        <x-alert />
                        <table class="faq-list-table table">
                            <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>{{__('Question')}}</th>
                                <th>{{__('Action')}}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
                <!-- list section end -->
            </section>
            <div class="modal fade" id="modals-create-faqs">
                <div class="modal-dialog">
                    <form class="create-new-nature modal-content pt-0"
                          action="{{ route('faqs.store') }}" method="POST">
                        @csrf
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('Add New Question') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">
                            <input type="hidden" name="key" value="PROJECT_NATURES">
                            <input type="hidden" name="category" value="1">

                            <div class="form-group">
                                <label for="username">{{ __('Question') }}</label>
                                <input type="text" class="form-control"
                                       placeholder="Question"
                                       name="question" value="{{ old('question') }}" id="question" required>
                            </div>

                            <div class="form-group">
                                <label for="username">{{ __('Description') }}</label>
                                <textarea name="description" id="description" class="form-control" rows="4">{{ old('description') }}</textarea>

                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('Save') }}</button>
                            <button type="reset" class="btn btn-outline-secondary"
                                    data-dismiss="modal">{{ __('Cancel') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            @foreach ($faqs as $item)
            <div class="modal fade" id="modals-update-faqs{{ $item->id }}">
                <div class="modal-dialog">
                    <form class="create-new-nature modal-content pt-0"
                          action="{{ route('faqs.update',$item->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('Edit Question') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">

                            <div class="form-group">
                                <label for="username">{{ __('Question') }}</label>
                                <input type="text" class="form-control"
                                       placeholder="Question"
                                       name="question" value="{{ old('question',$item->question) }}" id="question" required>
                            </div>

                            <div class="form-group">
                                <label for="username">{{ __('Description') }}</label>
                                <textarea name="description" id="description" class="form-control" rows="4">{{ old('description',$item->description) }}</textarea>

                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('Save') }}</button>
                            <button type="reset" class="btn btn-outline-secondary"
                                    data-dismiss="modal">{{ __('Cancel') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            @endforeach



            @foreach ($faqs as $item)
            <div class="modal fade" id="modals-delete-faqs{{ $item->id }}">
                <div class="modal-dialog">
                    <form class="create-new-nature modal-content pt-0"
                          action="{{ route('faqs.destroy',$item->id) }}" method="POST">
                        @csrf
                        @method('delete')
                        <div class="modal-header mb-1">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('Delete Question') }}</h5>
                        </div>
                        <div class="modal-body flex-grow-1">
                            <div class="form-group">
                                <label for="username">{{__('هل انت متأكد من الحذف')}}</label>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary mr-1 data-submit">{{ __('Save') }}</button>
                            <button type="reset" class="btn btn-outline-secondary"
                                    data-dismiss="modal">{{ __('Cancel') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            @endforeach

        </div>
    </div>
@endsection

@section('js')
    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/responsive.bootstrap4.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.buttons.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/jszip.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/tables/datatable/dataTables.rowGroup.min.js') }}"></script>
    <script src="{{ asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js') }}"></script>

    <!-- END: Page Vendor JS-->

    <script>
        const create = '{{ __('+ Add new') }}'
    </script>

    <!-- BEGIN: Page JS-->
    <script src="{{asset('app-assets/js/emad.js')}}"></script>
    {{--    <script src="{{asset('app-assets/js/datatables.js')}}"></script>--}}
    <!-- END: Page JS-->

@stop




