/*=========================================================================================
    File Name: app-user-list.js
    Description: User List page
    --------------------------------------------------------------------------------------
    Item Name: Vuexy  - Vuejs, HTML & Laravel Admin Dashboard Template
    Author: PIXINVENT
    Author URL: http://www.themeforest.net/user/pixinvent

==========================================================================================*/
$(function () {
    'use strict';

    var dtUserTable = $('.user-list-table'),
        dtClintOpinionsTable = $('.client-opinion-list-table'),
        dtPriseTable = $('.prise-list-table'),
        dtServiceTable = $('.service-list-table'),
        dtMenuTable = $('.menu-list-table'),
        dtSubMenuTable = $('.sub-menu-list-table'),
        dtSubserviceTable = $('.subservice-list-table'),
        dtPageTable = $('.page-list-table'),
        dtBlogTable = $('.blog-list-table'),
        dtStudyCaseTable = $('.study-cases-list-table'),
        dtTeamTable = $('.team-list-table'),
        dtSliderTable = $('.slider-list-table'),
        dtPartnersTable = $('.partners-list-table'),
        dtStudyCategoriesTable = $('.study-categories-list-table'),
        dtClientsTable = $('.clients-list-table'),
        dtSubCategoryTable = $('.sub-categories-list-table'),
        dtStepsTable = $('.steps-list-table'),
        dtContactTable = $('.contact-list-table'),
        dtOrderProductsTable = $('.order-products-list-table'),
        dtFAQsTable = $('.faq-list-table'),
        dtCategoryTable = $('.category-list-table'),
        dtBenefitTable = $('.benefit-list-table'),
        dtProductTable = $('.product-list-table'),



        status = {
            0: {title: 'غير مقروءه', class: 'badge-light-danger'},
            1: {title: 'مقروءه', class: 'badge-light-success'},
        },

        statusOrder = {
            'new': {title: 'جديد', class: 'badge-light-success'},
            'continued': {title: 'سيتم المتابعة', class: 'badge-light-info'},
            'followed': {title: 'تم المتابعة', class: 'badge-light-success'},
            'end': {title: 'انتهى', class: 'badge-light-success'},
        };


    // Users List datatable
    if (dtUserTable.length) {
        dtUserTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/users'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'name'},
                {data: 'email'},
                {data: 'role'},
                {data: 'phone'},
                {data: 'actions', orderable: false}
            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    }
                },

                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '/control-panel/users/create'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],
            initComplete: function () {
                // Adding role filter once table initialized
                this.api()
                    .columns(2)
                    .every(function () {
                        var column = this;
                        var select = $(
                            '<select id="UserRole" class="form-control text-capitalize mb-md-0 mb-2"><option value=""> اختار الصلاحية </option></select>'
                        )
                            .appendTo('.user_role')
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                console.log(val);
                                column.search(val ? val : '', true, false).draw();
                            });

                        column
                            .data()
                            .unique()
                            .sort()
                            .each(function (d, j) {
                                select.append('<option value="' + d + '" class="text-capitalize">' + d + '</option>');
                            });
                    });

            }

        });
    }


    if (dtClintOpinionsTable.length) {
        dtClintOpinionsTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/client-opinion'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name_ar'},
                {data: 'name'},
                {data: 'client_position_ar'},
                {data: 'client_position'},
                {data: 'actions', orderable: false}
            ],

            order: [1, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '/control-panel/client-opinion/create'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtPriseTable.length) {
        dtPriseTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/prises'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'icon', orderable: false},
                {data: 'name'},
                {data: 'number'},
                {data: 'actions', orderable: false}
            ],

            order: [1, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '/control-panel/prises/create'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtServiceTable.length) {
        dtServiceTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name'},
                {data: 'description'},
                {data: 'actions', orderable: false}
            ],
            columnDefs: [
                {
                    // Actions
                    targets: 2,
                    width: '300 px',
                }

            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtSubserviceTable.length) {
        dtSubserviceTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name'},
                {data: 'parent'},
                {data: 'description'},
                {data: 'actions', orderable: false}
            ],
            columnDefs: [
                {
                    // Actions
                    targets: 2,
                    width: '300 px',
                }

            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtMenuTable.length) {
        dtMenuTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/menus'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'DT_RowIndex'},
                {data: 'name_ar'},
                {data: 'name'},
                {data: 'link'},
                {data: 'parent'},
                {data: 'actions', orderable: false}
            ],


            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '>',

        });
    }

    if (dtSubMenuTable.length) {
        dtSubMenuTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/sub-menus'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'name'},
                {data: 'parent'},
                {data: 'actions', orderable: false}
            ],
            columnDefs: [
                {
                    // Actions
                    targets: 2,
                    width: '300 px',
                }

            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '/control-panel/sub-menus/create'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }



    if (dtPageTable.length) {
        dtPageTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/pages'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'main_image', orderable: false},
                {data: 'title'},
                {data: 'sub_title'},
                {data: 'actions', orderable: false}
            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '/control-panel/pages/create'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }


    if (dtStudyCaseTable.length) {
        dtStudyCaseTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'main_image', orderable: false},
                {data: 'title'},
                {data: 'sub_title'},
                {data: 'actions', orderable: false}
            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtBlogTable.length) {
        dtBlogTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'main_image', orderable: false},
                {data: 'title'},
                {data: 'sub_title'},
                {data: 'type'},
                {data: 'actions', orderable: false}
            ],

            order: [0, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtTeamTable.length) {
        dtTeamTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name'},
                {data: 'position'},
                {data: 'actions', orderable: false}
            ],

            order: [1, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtSliderTable.length) {
        dtSliderTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'title'},
                {data: 'sub_title'},
                {data: 'link'},
                {data: 'actions', orderable: false}
            ],

            order: [1, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3, 4]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3, 4]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3, 4]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    onclick: "",
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }

                },
            ],

        });
    }

    if (dtContactTable.length) {
        dtContactTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/contacts'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'name'},
                {data: 'email'},
                {data: 'subject'},
                {data: 'date'},
                {data: 'status'},
                {data: 'actions', orderable: false}
            ],
            columnDefs: [
                {
                    // Slider Status
                    targets: 4,
                    render: function (data, type, full, meta) {
                        var $status = full['status'];

                        return (
                            '<span class="badge badge-pill ' +
                            status[$status].class +
                            '" text-capitalized>' +
                            status[$status].title +
                            '</span>'
                        );
                    }
                },
            ],
            order: [4, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                }
            ],

        });
    }

    if (dtOrderProductsTable.length) {
        dtOrderProductsTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/order-products'
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'full_name'},
                {data: 'email'},
                {data: 'product'},
                {data: 'quentity'},
                {data: 'date'},
                {data: 'status'},
                {data: 'actions', orderable: false}
            ],
            columnDefs: [
                {
                    // Slider Status
                    targets: 5,
                    render: function (data, type, full, meta) {
                        var $status = full['status'];

                        return (
                            '<span class="badge badge-pill ' +
                            status[$status].class +
                            '" text-capitalized>' +
                            status[$status].title +
                            '</span>'
                        );
                    }
                },
            ],
            order: [4, 'asc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3, 4]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3, 4]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3, 4]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                }
            ],

        });
    }


    if (dtFAQsTable.length) {
        dtFAQsTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: '/control-panel/faqs'
            },
            columns: [
                // columns according to JSON
                {data: 'DT_RowIndex'},
                {data: 'question'},
                {data: 'actions'}
            ],

            order: [[0, 'desc']],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create-faqs'
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ]
        });
    }


    if (dtCategoryTable.length) {
        dtCategoryTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'DT_RowIndex'},
                {data: 'name_ar'},
                {data: 'name_en'},
                {data: 'actions', orderable: false}
            ],
            order: [0, 'desc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create'
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }


    if (dtBenefitTable.length) {
        dtBenefitTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl,
                data: {product_id: productID}
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'DT_RowIndex'},
                {data: 'title'},
                {data: 'sub_title'},
                {data: 'product'},
                {data: 'actions', orderable: false}
            ],
            order: [0, 'desc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    text: addnew,
                    className: 'add-new btn btn-sm btn-primary mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create-benefit'
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                },
                {
                    text: createOther,
                    className: 'add-new btn btn-sm btn-success mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create-other-benefit'
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }


    if (dtProductTable.length) {
        dtProductTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: mainUrl
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'id'},
                {data: 'main_image'},
                {data: 'name'},
                {data: 'price'},
                {data: 'category'},
                {data: 'created_at'},
                {data: 'actions', orderable: false}
            ],
            order: [0, 'desc'],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'exports',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'prints',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'excel',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1, 2, 3]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    },
                },
                {
                    text: addnew,
                    className: 'add-new btn btn-primary mt-50',
                    attr: {
                        "type": "button",
                        "onclick": "location.href = '"+createUrl+"'",
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }


    if (dtPartnersTable.length) {
        dtPartnersTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: indexUrl,
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name', orderable: false},
                {data: 'actions', orderable: false}
            ],

            order: [2],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    }
                },

                {
                    text: addnew,
                    className: 'add-new btn btn-primary mr-2 mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create',
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }


    if (dtStudyCategoriesTable.length) {
        dtStudyCategoriesTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: indexUrl,
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'id', orderable: false},
                {data: 'name', orderable: false},
                {data: 'actions', orderable: false}
            ],

            order: [2],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [0, 1]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    }
                },

                {
                    text: addnew,
                    className: 'add-new btn btn-primary mr-2 mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create',
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }

    if (dtClientsTable.length) {
        dtClientsTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: indexUrl,
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name', orderable: false},
                {data: 'actions', orderable: false}
            ],

            order: [2],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    }
                },

                {
                    text: addnew,
                    className: 'add-new btn btn-primary mr-2 mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create',
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }

    if (dtSubCategoryTable.length) {
        dtSubCategoryTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: indexUrl,
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'name', orderable: false},
                {data: 'category', orderable: false},
                {data: 'actions', orderable: false}
            ],

            order: [2],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1, 2]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1, 2]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1, 2]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    }
                },

                {
                    text: addnew,
                    className: 'add-new btn btn-primary mr-2 mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create',
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }


    if (dtStepsTable.length) {
        dtStepsTable.DataTable({
            "processing": true,
            "serverSide": true,
            ajax: {
                url: indexUrl,
            }, // JSON file to add data
            columns: [
                // columns according to JSON
                {data: 'image', orderable: false},
                {data: 'title', orderable: false},
                {data: 'actions', orderable: false}
            ],

            order: [2],
            dom:
                '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                '<"col-lg-12 col-xl-6" l>' +
                '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                '>t' +
                '<"d-flex justify-content-between mx-2 row mb-1"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            language: {
                sLengthMenu: sLengthMenu,
                search: search1,
                zeroRecords: zeroRecords,
                info: info1,
                infoEmpty: infoEmpty,
                searchPlaceholder: '',
                paginate: {
                    // remove previous & next text from pagination
                    previous: '&nbsp;',
                    next: '&nbsp;'
                }
            },
            // Buttons with Dropdown
            buttons: [
                {
                    extend: 'collection',
                    className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                    text: feather.icons['share'].toSvg({class: 'font-small-4 mr-50'}) + 'تصدير',
                    buttons: [
                        {
                            extend: 'print',
                            text: feather.icons['printer'].toSvg({class: 'font-small-4 mr-50'}) + 'طباعة',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        },
                        {
                            extend: 'excel',
                            text: feather.icons['file'].toSvg({class: 'font-small-4 mr-50'}) + 'اكسل',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        },
                        {
                            extend: 'pdf',
                            text: feather.icons['clipboard'].toSvg({class: 'font-small-4 mr-50'}) + 'Pdf',
                            className: 'dropdown-item',
                            exportOptions: {columns: [1]}
                        }
                    ],
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                        $(node).parent().removeClass('btn-group');
                        setTimeout(function () {
                            $(node).closest('.dt-buttons').removeClass('btn-group').addClass('d-inline-flex');
                        }, 50);
                    }
                },

                {
                    text: addnew,
                    className: 'add-new btn btn-primary mr-2 mt-50',
                    attr: {
                        'data-toggle': 'modal',
                        'data-target': '#modals-create',
                    },
                    init: function (api, node, config) {
                        $(node).removeClass('btn-secondary');
                    }
                }
            ],

        });
    }
});
