<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStudyCategoryIdToStudyCasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('study_cases', function (Blueprint $table) {
            $table->foreignId('study_category_id')->nullable()->constrained('study_categories')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('study_cases', function (Blueprint $table) {
            $table->dropConstrainedForeignId('study_category_id');
        });
    }
}
