<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddHeaderDescriptionToPagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->string('header_image')->after('sub_title')->nullable();
            $table->string('feature_title')->after('menu_id')->nullable();
            $table->string('feature_title_ar')->after('feature_title')->nullable();
            $table->string('feature_sub_title')->after('feature_title_ar')->nullable();
            $table->string('feature_sub_title_ar')->after('feature_sub_title')->nullable();
            $table->string('theme_title')->after('feature_sub_title_ar')->nullable();
            $table->string('theme_title_ar')->after('theme_title')->nullable();
            $table->string('theme_sub_title')->after('theme_title_ar')->nullable();
            $table->string('theme_sub_title_ar')->after('theme_sub_title')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn([
                'header_image', 'feature_title', 'feature_title_ar', 'feature_sub_title', 'feature_sub_title_ar', 'theme_title',
                'theme_title_ar', 'theme_sub_title', 'theme_sub_title_ar'
            ]);
        });
    }
}
