<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAboutUsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('about_us', function (Blueprint $table) {
            $table->id();
            $table->string('slider_title')->nullable();
            $table->string('slider_sub_title')->nullable();
            $table->string('slider_image')->nullable();
            $table->text('slider_description')->nullable();

            $table->string('title')->nullable();
            $table->string('sub_title')->nullable();
            $table->text('description')->nullable();
            $table->string('image')->nullable();

            $table->string('slider_title_ar')->after('slider_title')->nullable();
            $table->string('slider_sub_title_ar')->after('slider_sub_title')->nullable();
            $table->text('slider_description_ar')->after('slider_description')->nullable();

            $table->string('title_ar')->after('title')->nullable();

            $table->string('sub_title_ar')->after('sub_title')->nullable();

            $table->text('description_ar')->after('description')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('about_us');
    }
}
