<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientOpinionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_opinions', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->text('message')->nullable();
            $table->string('image')->nullable();
            $table->string('client_position')->nullable();
            $table->string('name_ar')->after('name')->nullable();
            $table->text('message_ar')->after('message')->nullable();
            $table->string('client_position_ar')->after('client_position')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_opinions');
    }
}
