<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menus', function (Blueprint $table) {
            $table->id();
            $table->string('name')->default(null);
            $table->string('link')->default(null);
            $table->foreignId('parent_id')->nullable()->constrained('menus')->nullOnDelete();
            $table->string('slug')->nullable()->unique();
            $table->enum('status',[0,1])->default(0);
            $table->string('name_ar')->after('name')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menus');
    }
}
