<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWebsitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('websits', function (Blueprint $table) {
            $table->id();
            $table->string('websit_title');
            $table->string('websit_title_ar')->after('websit_title')->nullable();
            $table->string('favicon_image');
            $table->string('logo');
            $table->string('seo_keyword')->nullable();
            $table->string('email')->unique();
            $table->string('telephone_number')->unique();
            $table->string('phone')->unique();
            $table->string('facebook')->nullable();
            $table->string('twitter')->nullable();
            $table->string('youtube')->nullable();
            $table->string('instagram')->nullable();
            $table->string('whatsapp')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('behance')->nullable();
            $table->string('url')->default('http://localhost:8000');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('websits');
    }
}
