<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudyCase extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'sub_title', 'main_image', 'description','title_ar', 'sub_title_ar',
        'description_ar', 'shot_desc_ar', 'shot_desc', 'study_category_id'
    ];

    public function images()
    {
        return $this->hasMany(StudyCaseImage::class,'study_case_id','id');
    }

    public function studyCategory()
    {
        # code...
        return $this->belongsTo(StudyCategory::class, 'study_category_id', 'id');
    }
}
