<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar', 'name_en',
        'short_description_ar', 'short_description_en',
        'big_description_en', 'big_description_ar',
        'sub_category_id', 'main_image', 'file', 'code', 'price', 'link'
    ];

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class,'sub_category_id','id');
    }

    public function benefit()
    {
        return $this->hasMany(Benefit::class);
    }

    public function images()
    {
        return $this->hasMany(Images::class);
    }

    public function orders()
    {
        # code...
        return $this->hasMany(OrderProduct::class, 'product_id', 'id');
    }

    public function getIdYoutube()
    {
        parse_str(parse_url($this->link, PHP_URL_QUERY), $my_array_of_vars);
        return $my_array_of_vars['v'];
    }
}
