<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $fillable = [
        'title', 'sub_title', 'header_image', 'main_image', 'description',
        'title_ar', 'sub_title_ar', 'description_ar', 'menu_id',
        'feature_title', 'feature_title_ar', 'feature_sub_title', 'feature_sub_title_ar',
        'theme_title', 'theme_title_ar', 'theme_sub_title', 'theme_sub_title_ar'
    ];


    public function images()
    {
        return $this->hasMany(PageImage::class,'page_id','id');
    }

    public function tags()
    {
        return $this->belongsToMany(Tag::class,'page_tags','page_id','tag_id','id','id');
    }

    public function menu()
    {
        # code...
        return $this->belongsTo(Menu::class,'menu_id','id');
    }

    public function features()
    {
        # code...
        return $this->hasMany(PageFeature::class, 'page_id', 'id');
    }

    public function themes()
    {
        # code...
        return $this->hasMany(PageTheme::class, 'page_id', 'id');
    }
}
