<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Benefit extends Model
{
    use HasFactory;

    protected $fillable = [
        'sub_title_en','sub_title_ar','title_en',
        'title_ar','description_ar','description_en',
        'product_id','status','image'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function subBenefits()
    {
        return $this->hasMany(SubBenefit::class);
    }
}
