<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|string',
            'title_ar' => 'required|string',
            'sub_title' => 'nullable|string',
            'sub_title_ar' => 'nullable|string',
            'image' => 'image',
            'link' => 'url|nullable',
            'description' => 'nullable|string|max:250',
            'description_ar' => 'nullable|string|max:250'
        ];
    }
}
