<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSubServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required |max:50',
            'name_ar' => 'required |max:50',
            'image' => 'nullable |image |mimes:png',
            'service_id' => 'required |exists:services,id',
            'description' => 'nullable |max:500',
            'description_ar' => 'nullable |max:500',
        ];
    }
}
