<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreProductsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name_ar' => 'required|string',
            'name_en' => 'required|string',
            'link' => 'required|url',
            'code' => 'nullable|string',
            'price' => 'required|numeric',
            'category_id' => 'required|exists:categories,id',
            'sub_category_id' => 'required|exists:sub_categories,id',
            'short_description_ar' => 'required|string',
            'short_description_en' => 'required|string',
            'big_description_ar' => 'nullable|string',
            'big_description_en' => 'nullable|string',
            'main_image' => 'image|required|mimes:png,jpg',
            'file' => 'required|mimes:jpg,pdf',
            'gallery' => 'array|nullable',
            'gallery.*' => 'mimes:png,jpg',
        ];
    }
}
