<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required |max:150',
            'title_ar' => 'required |max:150',
            'main_image' => 'required |image |mimes:png,jpg',
            'header_image' => 'required |image |mimes:png,jpg',
            'menu_id' => 'required|exists:menus,id',
            'sub_title' => 'nullable |string',
            'sub_title_ar' => 'nullable |string',
            'gallery' => 'nullable |array ',
            'description' => 'nullable',
            'description_ar' => 'nullable',
            'feature_title_ar' => 'nullable|string',
            'feature_title' => 'nullable|string',
            'feature_sub_title_ar' => 'nullable|string',
            'feature_sub_title' => 'nullable|string',
            'theme_title_ar' => 'nullable|string',
            'theme_title' => 'nullable|string',
            'theme_sub_title_ar' => 'nullable|string',
            'theme_sub_title' => 'nullable|string',
            'tags' => 'nullable |string',

        ];
    }
}
