<?php

namespace App\Http\Controllers;

use App\Models\AboutUs;
use App\Models\Blog;
use App\Models\Contact;
use App\Models\OrderProduct;
use App\Models\Page;
use App\Models\Product;
use App\Models\StudyCase;
use App\Models\SubCategory;
use Illuminate\Http\Request;

class SiteController extends Controller
{
    public function index()
    {
        # code...
        return view('front.index');
    }

    public function storeContact(Request $request)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'email|required|max:255',
            'phone' => 'required|string',
            'subject' => 'required|string|max:255',
            'message' => 'required|string'
        ]);

        Contact::create($request->all());

        return redirect()->back()->with('success', __('تم ارسال طلبك بنجاح'));
    }

    public function page(Page $page)
    {
        # code...
        return view('front.pages',[
            'page' => $page
        ]);
    }

    public function about()
    {
        # code...
        $about = AboutUs::first();

        return view('front.about-us', [
            'about' => $about ?? new AboutUs(),
        ]);
    }

    public function contact()
    {
        # code...
        return view('front.contact',['']);
    }

    public function blogs()
    {
        # code...
        $blogs = Blog::where('type','0')->latest()->paginate(6);

        return view('front.blogs', [
            'blogs' => $blogs
        ]);
    }

    public function press()
    {
        # code...
        $blogs = Blog::where('type','1')->latest()->paginate(6);

        return view('front.blogs', [
            'blogs' => $blogs
        ]);
    }

    public function blogDetials(Blog $blog)
    {
        # code...
        return view('front.blog', [
            'blog' => $blog
        ]);
    }

    public function caseStudy()
    {
        # code...
        $study_cases = StudyCase::latest()->paginate(3);

        return view('front.study-cases', [
            'study_cases' => $study_cases,

        ]);
    }


    public function caseStudyDetials(StudyCase $study_case)
    {
        # code...
        return view('front.study-case', [
            'study_case' => $study_case
        ]);
    }


    public function products(SubCategory $sub)
    {
        # code...
        return view('front.products', [
            'sub_category' => $sub
        ]);
    }


    public function productDetails(Product $product)
    {
        # code...
        return view('front.product', [
            'product' => $product
        ]);
    }


    public function productOrder(Request $request, Product $product)
    {
        # code...
        // dd($request->all());
        $request->validate([
            'full_name' => 'required|string|max:255',
            'quentity' => 'required|numeric',
            'email' => 'email|required|max:255',
            'phone' => 'required|string',
            'company_name' => 'required|string|max:255',
            'message' => 'required|string'
        ]);

        $product->orders()->create($request->all());

        return redirect()->back()->with('success', __('تم ارسال طلبك بنجاح'));
    }
}
