<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\SubCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class SubCategoriesContoller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = SubCategory::select('count(*) as allcount')->count();
            $totalRecordswithFilter = SubCategory::select('count(*) as allcount')
                                                ->where('name', 'like', '%' . $searchValue . '%')
                                                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                                                ->count();

            $sub_categories = SubCategory::select('sub_categories.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('sub_categories.id', 'desc')
                ->get();


            $records = [];

            foreach($sub_categories as $item)
            {
                $name = '';
                $category = '';
                if(LaravelLocalization::getCurrentLocale() == 'ar') {
                    $name = $item->name_ar;
                    $category = $item->category->name_ar;
                }else{
                    $name = $item->name;
                    $category = $item->category->name_en;
                }
                $records[] = [
                       'image' => '<img src="'. asset('storage/'.$item->image) .'" width="80">',
                       'name' => $name,
                       'category' => $category,
                       'actions' => view('control-panel.sub_categories.datatable.buttons',[ 'item' => $item ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }

        return view('control-panel.sub_categories.index');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'category_id' => 'required|exists:categories,id',
            'description' => 'required|string|max:255',
            'description_ar' => 'required|string|max:255',
            'image' => 'required|mimes:png,jpg',
        ]);

        $image = null;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            $image = $request->file('image')->store('sub-categories','public');
        }

        SubCategory::create([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
            'category_id' => $request->category_id,
            'description' => $request->description,
            'description_ar' => $request->description_ar,
            'image' => $image,
        ]);

        return redirect()->route('sub-categories.index')->with('success', __('تم الاضافة بنجاح') );

    }

    public function update(Request $request, SubCategory $sub_category)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'category_id' => 'required|exists:categories,id',
            'description' => 'required|string|max:255',
            'description_ar' => 'required|string|max:255',
            'image' => 'nullable|mimes:png,jpg',
        ]);

        $image = $sub_category->image;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('sub-categories','public');
        }

        $sub_category->update([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
            'category_id' => $request->category_id,
            'description' => $request->description,
            'description_ar' => $request->description_ar,
            'image' => $image,
        ]);

        return redirect()->route('sub-categories.index')->with('success',__('تم التعديل بنجاح'));
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(SubCategory $sub_category)
    {

        $sub_category->delete();
        Storage::disk('public')->delete($sub_category->image);
        return redirect()->route('sub-categories.index')->with('success',__('تم الحذف بنجاح'));
    }

    public function getSubCategories($category_id = 0)
    {
        $sub_categories = SubCategory::where('category_id', $category_id)->get();
        return response()->json($sub_categories);
    }
}
