<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\StudyCategory;
use Illuminate\Http\Request;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class StudyCategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = StudyCategory::select('count(*) as allcount')->count();
            $totalRecordswithFilter = StudyCategory::select('count(*) as allcount')
                                                ->where('name', 'like', '%' . $searchValue . '%')
                                                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                                                ->count();

            $study_categories = StudyCategory::select('study_categories.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('study_categories.id', 'desc')
                ->get();


            $records = [];

            foreach($study_categories as $item)
            {
                $name = '';
                if(LaravelLocalization::getCurrentLocale() == 'ar') {
                    $name = $item->name_ar;
                }else{
                    $name = $item->name;
                }
                $records[] = [
                       'id' => $item->id,
                       'name' => $name,
                       'actions' => view('control-panel.study_categories.datatable.buttons',[ 'item' => $item ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }

        return view('control-panel.study_categories.index');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
        ]);

        StudyCategory::create([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
        ]);

        return redirect()->route('study-categories.index')->with('success', __('تم الاضافة بنجاح') );

    }

    public function update(Request $request, StudyCategory $study_category)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
        ]);

        $study_category->update([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
        ]);

        return redirect()->route('study-categories.index')->with('success',__('تم التعديل بنجاح'));
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(StudyCategory $study_category)
    {

        $study_category->delete();
        return redirect()->route('study-categories.index')->with('success',__('تم الحذف بنجاح'));
    }

}
