<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Step;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class StepsContoller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Step::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Step::select('count(*) as allcount')
                                                ->where('title', 'like', '%' . $searchValue . '%')
                                                ->orWhere('title_ar', 'like', '%' . $searchValue . '%')
                                                ->count();

            $steps = Step::select('steps.*')
                ->where('title', 'like', '%' . $searchValue . '%')
                ->orWhere('title_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('steps.id', 'desc')
                ->get();


            $records = [];

            foreach($steps as $item)
            {
                $title = '';
                if(LaravelLocalization::getCurrentLocale() == 'ar') {
                    $title = $item->title_ar;
                }else{
                    $title = $item->title;
                }
                $records[] = [
                       'image' => '<img src="'. asset('storage/'.$item->image) .'" width="80">',
                       'title' => $title,
                       'actions' => view('control-panel.steps.datatable.buttons',[ 'item' => $item ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }

        return view('control-panel.steps.index');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'description_ar' => 'required|string|max:255',
            'image' => 'required|mimes:png,jpg',
        ]);

        $image = null;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            $image = $request->file('image')->store('steps','public');
        }

        Step::create([
            'title' => $request->title,
            'title_ar' => $request->title_ar,
            'description' => $request->description,
            'description_ar' => $request->description_ar,
            'image' => $image,
        ]);

        return redirect()->route('steps.index')->with('success', __('تم الاضافة بنجاح') );

    }

    public function update(Request $request, Step $step)
    {
        # code...
        $request->validate([
            'title' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'description_ar' => 'required|string|max:255',
            'image' => 'nullable|mimes:png,jpg',
        ]);

        $image = $step->image;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('steps','public');
        }

        $step->update([
            'title' => $request->title,
            'title_ar' => $request->title_ar,
            'description' => $request->description,
            'description_ar' => $request->description_ar,
            'image' => $image,
        ]);

        return redirect()->route('steps.index')->with('success',__('تم التعديل بنجاح'));
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Step $step)
    {

        $step->delete();
        Storage::disk('public')->delete($step->image);
        return redirect()->route('steps.index')->with('success',__('تم الحذف بنجاح'));
    }

}
