<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\ServiceText;
use Illuminate\Http\Request;

class ServiceTextController extends Controller
{
 /**
     * this function for view website edit page
     *
     * @return \Illuminate\View\View
     */
    public function edit()
    {
        $service_text = ServiceText::latest()->first();


        return view('control-panel.service_text.edit',[
            'service_text' => $service_text,
        ]);
    }


    /**
     * this function for update website setting in database or create new setting
     *
     * @param Illuminate\Http\Request $request
     *
     * @return \Illuminate\View\View
     */
    public function update(Request $request){

        $service_text = ServiceText::latest()->first();

        if(!$service_text){
            $request->validate([
                'title' => 'required |string',
                'sub_title' => 'string|nullable',
                'description' => 'required |string |max:250',
                'title1' => 'required |string',
                'description1' => 'required |string |max:250',
                'title2' => 'required |string',
                'description2' => 'required |string |max:250',
                'title_ar' => 'required |string',
                'sub_title_ar' => 'string|nullable',
                'description_ar' => 'required |string |max:250',
                'title1_ar' => 'required |string',
                'description1_ar' => 'required |string |max:250',
                'title2_ar' => 'required |string',
                'description2_ar' => 'required |string |max:250',
            ]);
            $data = $request->all();

            $service = ServiceText::create($data);
        }else{
            $request->validate([
                'title' => 'required |string',
                'sub_title' => 'string|nullable',
                'description' => 'required |string |max:250',
                'title1' => 'required |string',
                'description1' => 'required |string |max:250',
                'title2' => 'required |string',
                'description2' => 'required |string |max:250',
                'title_ar' => 'required |string',
                'sub_title_ar' => 'string|nullable',
                'description_ar' => 'required |string |max:250',
                'title1_ar' => 'required |string',
                'description1_ar' => 'required |string |max:250',
                'title2_ar' => 'required |string',
                'description2_ar' => 'required |string |max:250',
            ]);
            $data = $request->all();

            $service = $service_text;
            $service->update($data);
        }

        return redirect()->route('service-text-edit',[
            'service_text' => $service
        ])->with('success',__('Update Done!'));

    }
}
