<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Prise;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PriseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $prises = Prise::all();
            return datatables()->of($prises)
                ->editColumn('icon', function (Prise $prise) {
                    return '<img src="' . asset('storage/' . $prise->icon) . '" width="50" alt="' . $prise->name . '">';
                })
                ->addColumn('actions', function (Prise $prise) {
                    $delete = '';
                    $delete = '<a href="#" class="btn btn-danger btn-sm" data-toggle= "modal" data-target= "#modals-delete-' . $prise->id . '">' .
                        __('حذف').'</a>';
                    $edit = ' <a href="' . route('prises.edit', $prise->id) . '" class="btn btn-sm btn-primary">'.__('تعديل').'</a>';

                    return $delete . $edit;

                })
                ->rawColumns(['actions', 'icon'])
                ->make(true);
        }
        $prises = Prise::all();

        return view('control-panel.prises.index', [
            'prises' => $prises,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('control-panel.prises.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'string |required',
            'icon' => 'mimes:png|required',
            'number' => 'required|numeric',
        ]);

        $data = $request->all();

        $icon = null;
        if ($request->hasFile('icon') && $request->file('icon')->isValid()) {
            $icon = $request->file('icon')->store('prises', 'public');
        }

        $data['icon'] = $icon;

        Prise::create($data);

        return redirect()->route('prises.index')->with('success','تم انشاء الاحصائية بنجاح');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Prise $prise)
    {
        // dd($client_opinion);
        return view('control-panel.prises.edit',[
            'prise' => $prise,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,Prise $prise)
    {
        $request->validate([
            'name' => 'required|string',
            'icon' => 'nullable|mimes:png',
            'number' => 'required|numeric',
        ]);

        $data = $request->all();

        $icon = $prise->icon;
        if ($request->hasFile('icon') && $request->file('icon')->isValid()) {
            Storage::disk('public')->delete($icon);
            $icon = $request->file('icon')->store('prises', 'public');
        }

        $data['icon'] = $icon;

        $prise->update($data);

        return redirect()->route('prises.index')->with('success','تم التعديل على الاحصائية بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Prise $prise)
    {
        Storage::disk('public')->delete($prise->icon);
        $prise->delete();
        return redirect()->route('prises.index')->with('success','تم حذف الاحصائية بنجاح');
    }
}
