<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Partner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class PartnersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {

            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Partner::select('count(*) as allcount')->count();
            $totalRecordswithFilter = Partner::select('count(*) as allcount')
                                                ->where('name', 'like', '%' . $searchValue . '%')
                                                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                                                ->count();

            $partners = Partner::select('partners.*')
                ->where('name', 'like', '%' . $searchValue . '%')
                ->orWhere('name_ar', 'like', '%' . $searchValue . '%')
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('partners.id', 'desc')
                ->get();


            $records = [];

            foreach($partners as $item)
            {
                $name = '';
                if(LaravelLocalization::getCurrentLocale() == 'ar') {
                    $name = $item->name_ar;
                }else{
                    $name = $item->name;
                }
                $records[] = [
                       'image' => '<img src="'. asset('storage/'.$item->image) .'" width="80">',
                       'name' => $name,
                       'actions' => view('control-panel.partner.datatable.buttons',[ 'item' => $item ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }

        return view('control-panel.partner.index');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'image' => 'required|mimes:png,jpg',
        ]);

        $image = null;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            $image = $request->file('image')->store('partners','public');
        }

        Partner::create([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
            'image' => $image,
        ]);

        return redirect()->route('partners.index')->with('success', __('تم اضافة الشريك بنجاح') );

    }

    public function update(Request $request, Partner $partner)
    {
        # code...
        $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'required|string|max:255',
            'image' => 'nullable|mimes:png,jpg',
        ]);

        $image = $partner->image;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('partners','public');
        }

        $partner->update([
            'name' => $request->name,
            'name_ar' => $request->name_ar,
            'image' => $image,
        ]);

        return redirect()->route('partners.index')->with('success',__('تم التعديل على الشريك بنجاح'));
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Partner $partner)
    {

        $partner->delete();
        Storage::disk('public')->delete($partner->image);
        return redirect()->route('partners.index')->with('success',__('تم حذف الشريك بنجاح'));
    }

}
