<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Models\PageTheme;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PageThemesController extends Controller
{
    public function index(Page $page)
    {
        # code...
        return view('control-panel.pages.themes.index',[
            'page' => $page
        ]);
    }

    public function store(Request $request, Page $page)
    {
        # code...
        $request->validate([
            'image' => 'required|mimes:png,jpg',
            'title_ar' => 'required|string',
            'title' => 'required|string',
            'sub_title_ar' => 'required|string',
            'sub_title' => 'required|string',
            'description_ar' => 'required|string',
            'description' => 'required|string',
        ]);

        $data = $request->all();
        $image = null;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image')->store('themes', 'public');
            $data['image'] = $image;
        }

        $page->themes()->create($data);

        return redirect()->route('themes.index', $page->id)->with('success', __(' Created Done!'));

    }

    public function update(Request $request, PageTheme $theme)
    {
        # code...
        $request->validate([
            'image' => 'nullable|mimes:png,jpg',
            'title_ar' => 'required|string',
            'title' => 'required|string',
            'sub_title_ar' => 'required|string',
            'sub_title' => 'required|string',
            'description_ar' => 'required|string',
            'description' => 'required|string',
        ]);

        $data = $request->all();
        $image = $theme->image;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('themes', 'public');
            $data['image'] = $image;
        }

        $theme->update($data);

        return redirect()->route('themes.index', $theme->page_id)->with('success', __(' Updated Done!'));
    }

    public function destroy(PageTheme $theme)
    {
        # code...
        $theme->delete();
        return redirect()->route('themes.index', $theme->page_id)->with('success', __('Deleted Done'));
    }
}
