<?php

namespace App\Http\Controllers\ControlPanel;

use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Models\PageFeature;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PageFeaturesController extends Controller
{
    public function index(Page $page)
    {
        # code...
        return view('control-panel.pages.features.index',[
            'page' => $page
        ]);
    }

    public function store(Request $request, Page $page)
    {
        # code...
        $request->validate([
            'image' => 'required|mimes:png,jpg',
            'title_ar' => 'required|string',
            'title' => 'required|string',
            'description_ar' => 'required|string',
            'description' => 'required|string',
        ]);

        $data = $request->all();
        $image = null;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image')->store('features', 'public');
            $data['image'] = $image;
        }

        $page->features()->create($data);

        return redirect()->route('features.index', $page->id)->with('success', __(' Created Done!'));

    }

    public function update(Request $request, PageFeature $feature)
    {
        # code...
        $request->validate([
            'image' => 'nullable|mimes:png,jpg',
            'title_ar' => 'required|string',
            'title' => 'required|string',
            'description_ar' => 'required|string',
            'description' => 'required|string',
        ]);

        $data = $request->all();
        $image = $feature->image;

        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            Storage::disk('public')->delete($image);
            $image = $request->file('image')->store('features', 'public');
            $data['image'] = $image;
        }

        $feature->update($data);

        return redirect()->route('features.index', $feature->page_id)->with('success', __(' Updated Done!'));
    }

    public function destroy(PageFeature $feature)
    {
        # code...
        $feature->delete();
        return redirect()->route('features.index', $feature->page_id)->with('success', __('Deleted Done'));
    }
}
